package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChequePagos implements Serializable {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("estado")
    private Estado estado;

    @JsonProperty("beneficiario")
    private Beneficiario beneficiario;

    @JsonProperty("cuenta")
    private Cuenta cuenta;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Beneficiario getBeneficiario() {
        return beneficiario;
    }

    public void setBeneficiario(Beneficiario beneficiario) {
        this.beneficiario = beneficiario;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    @Override
    public String toString() {
        return "ChequePagos [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((beneficiario != null) ? "beneficiario=" + beneficiario + ", " : "") +
                ((cuenta != null) ? "cuenta=" + cuenta + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChequePagos that = (ChequePagos) o;
        return Objects.equals(id, that.id) && Objects.equals(estado, that.estado) && Objects.equals(beneficiario, that.beneficiario) && Objects.equals(cuenta, that.cuenta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, estado, beneficiario, cuenta);
    }
}