package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Egreso implements Serializable {

    @JsonProperty("medioPago")
    private MedioPago medioPago;

    @JsonProperty("importe")
    private Importe importe;

    public MedioPago getMedioPago() {
        return medioPago;
    }

    public void setMedioPago(MedioPago medioPago) {
        this.medioPago = medioPago;
    }

    public Importe getImporte() {
        return importe;
    }

    public void setImporte(Importe importe) {
        this.importe = importe;
    }

    @Override
    public String toString() {
        return "Egreso [" +
                ((medioPago != null) ? "medioPago=" + medioPago + ", " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Egreso egreso = (Egreso) o;
        return Objects.equals(medioPago, egreso.medioPago) && Objects.equals(importe, egreso.importe);
    }

    @Override
    public int hashCode() {
        return Objects.hash(medioPago, importe);
    }
}