package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.ArchivoEstado;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivoByIdResponse extends CommonResponse implements Serializable {

    @JsonProperty("archivo")
    private ArchivoEstado archivo;

    public ArchivoEstado getArchivo() {
        return archivo;
    }

    public void setArchivo(ArchivoEstado archivo) {
        this.archivo = archivo;
    }

    @Override
    public String toString() {
        return "EmpresaArchivoByIdResponse [" +
                ((archivo != null) ? "archivo=" + archivo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaArchivoByIdResponse that = (EmpresaArchivoByIdResponse) o;
        return Objects.equals(archivo, that.archivo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), archivo);
    }
}