package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.Error;
import ar.com.sdd.patagoniaapi.model.Pagina;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaArchivoErroresResponse extends CommonResponse implements Serializable {

    @JsonProperty("pagina")
    private Pagina pagina;

    @JsonProperty("errorLista")
    private List<Error> errores;

    public Pagina getPagina() {
        return pagina;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
    }

    public List<Error> getErrores() {
        return errores;
    }

    public void setErrores(List<Error> errores) {
        this.errores = errores;
    }

    @Override
    public String toString() {
        return "EmpresaArchivoErroresResponse [" +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                ((errores != null) ? "errores=" + Arrays.toString(errores.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaArchivoErroresResponse that = (EmpresaArchivoErroresResponse) o;
        return Objects.equals(pagina, that.pagina) && Objects.equals(errores, that.errores);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), pagina, errores);
    }
}