package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.ChequeCobros;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroChequesDetalleResponse extends CommonResponse implements Serializable {

    @JsonProperty("proximaPagina")
    private String proximaPagina;

    @JsonProperty("cheques")
    private List<ChequeCobros> cheques;

    public String getProximaPagina() {
        return proximaPagina;
    }

    public void setProximaPagina(String proximaPagina) {
        this.proximaPagina = proximaPagina;
    }

    public List<ChequeCobros> getCheques() {
        return cheques;
    }

    public void setCheques(List<ChequeCobros> cheques) {
        this.cheques = cheques;
    }

    @Override
    public String toString() {
        return "EmpresaCobroChequesDetalleResponse [" +
                ((proximaPagina != null) ? "proximaPagina='" + proximaPagina + "', " : "") +
                ((cheques != null) ? "cheques=" + Arrays.toString(cheques.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmpresaCobroChequesDetalleResponse that = (EmpresaCobroChequesDetalleResponse) o;
        return Objects.equals(proximaPagina, that.proximaPagina) && Objects.equals(cheques, that.cheques);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), proximaPagina, cheques);
    }
}