package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.MedioPago;
import ar.com.sdd.patagoniaapi.model.Recaudacion;
import ar.com.sdd.patagoniaapi.model.Resumen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmpresaCobroListadoResponse extends CommonResponse implements Serializable {

    @JsonProperty("medioPagoLista")
    private List<MedioPago> medioPago;

    @JsonProperty("recaudacionLista")
    private List<Recaudacion> recaudacion;

    @JsonProperty("resumenLista")
    private List<Resumen> resumen;

    public List<MedioPago> getMedioPago() {
        return medioPago;
    }

    public void setMedioPago(List<MedioPago> medioPago) {
        this.medioPago = medioPago;
    }

    public List<Recaudacion> getRecaudacion() {
        return recaudacion;
    }

    public void setRecaudacion(List<Recaudacion> recaudacion) {
        this.recaudacion = recaudacion;
    }

    public List<Resumen> getResumen() {
        return resumen;
    }

    public void setResumen(List<Resumen> resumen) {
        this.resumen = resumen;
    }

    @Override
    public String toString() {
        return "EmpresaCobroListadoResponse{" +
                "medioPago=" + medioPago +
                ", recaudacion=" + recaudacion +
                ", resumen=" + resumen +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmpresaCobroListadoResponse that = (EmpresaCobroListadoResponse) o;
        return Objects.equals(medioPago, that.medioPago) && Objects.equals(recaudacion, that.recaudacion) && Objects.equals(resumen, that.resumen);
    }

    @Override
    public int hashCode() {
        return Objects.hash(medioPago, recaudacion, resumen);
    }
}