/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoByIdResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoErroresResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoEstadoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoResponse;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenRequest;
import ar.com.sdd.patagoniaapi.io.EmpresaArchivoTokenResponse;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.ErrorResponse;
import ar.com.sdd.patagoniaapi.model.Respuesta;
import ar.com.sdd.patagoniaapi.model.Token;
import ar.com.sdd.patagoniaapi.model.Usuario;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PatagoniaApiConnectorBase
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(PatagoniaApiConnectorBase.class);
    protected final RestConnector restConnector;
    protected final String xApplicationId;
    protected final String usuarioAlias;
    protected final String documentoTipo;
    protected final String documentoNumero;
    protected final String adherente;
    protected final String convenio;
    protected final String docProd;
    protected static final String channel = "PT";
    private boolean doingLogin;
    private final int accessTokenTtl;
    private final SimpleCache cache = SimpleCacheManager.getInstance().getCache(PatagoniaApiConnectorBase.class.getName());
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    protected final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public PatagoniaApiConnectorBase(PatagoniaApiConnectorContext context) {
        this.usuarioAlias = context.getUsuarioAlias();
        this.documentoTipo = context.getDocumentoTipo();
        this.documentoNumero = context.getDocumentoNumero();
        this.xApplicationId = context.getXApplicationKey();
        this.adherente = context.getAdherente();
        this.convenio = context.getConvenio();
        this.docProd = context.getDocProd();
        this.accessTokenTtl = context.getAccessTokenTtl();
        log.debug("Creando PatagoniaApiConnector con " + context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public EmpresaArchivoEstadoResponse uploadFile(String fileName, String fileInBase64) throws RestConnectorException {
        log.debug("[uploadFile] Por hacer upload del archivo " + fileName);
        String userId = (String)this.cache.get("userId");
        String accessToken = (String)this.cache.get("accessToken");
        if (StringUtil.isEmpty((String)userId) || StringUtil.isEmpty((String)accessToken)) {
            Pair<LoginResponse, MultivaluedMap<String, Object>> loginResponse = this.login();
            userId = this.getUserId(((LoginResponse)loginResponse.getKey()).getUsuario().getUriOperador());
            this.cache.put("userId", (Object)userId);
            this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)loginResponse.getValue()));
        }
        String uploadToken = this.generateUploadToken();
        EmpresaArchivoRequest empresaArchivoRequest = new EmpresaArchivoRequest();
        empresaArchivoRequest.setToken(uploadToken);
        empresaArchivoRequest.setUserId(userId);
        empresaArchivoRequest.setFileName(fileName);
        empresaArchivoRequest.setFile(fileInBase64);
        String path = "/archivo";
        EmpresaArchivoResponse empresaArchivoResponse = (EmpresaArchivoResponse)this.restConnector.genericPost((Object)empresaArchivoRequest, EmpresaArchivoResponse.class, "/archivo", "application/json", "application/x-www-form-urlencoded");
        if (empresaArchivoResponse == null) {
            throw new RuntimeException("[uploadFile] El response de la subida del archivo " + fileName + " fue null");
        }
        if (empresaArchivoResponse.getRespuesta() == null) {
            throw new RuntimeException("[uploadFile] No se pudo obtener el parametro [respuesta] del response");
        }
        Respuesta respuesta = empresaArchivoResponse.getRespuesta();
        if (respuesta.getCodigo().equals(STATUS_OK)) {
            return this.confirmarOperacion(empresaArchivoRequest.getToken(), fileName);
        }
        return null;
    }

    private String getUserId(String uriOperador) {
        String uriSFB = uriOperador.split(";")[1];
        Optional<String> userId = Arrays.stream(uriSFB.split("#")).filter(s -> s.startsWith("B2B")).findFirst();
        if (userId.isEmpty()) {
            throw new RuntimeException("No se pudo obtener el userId del LoginResponse.Usuario.UriOperador [" + uriOperador + "]");
        }
        return userId.get();
    }

    public abstract EmpresaArchivoEstadoResponse confirmarOperacion(String var1, String var2) throws RestConnectorException;

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApplicationId);
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public Pair<LoginResponse, MultivaluedMap<String, Object>> login() throws RestConnectorException {
        Usuario usuario = new Usuario();
        usuario.setAlias(this.usuarioAlias);
        Documento documento = new Documento();
        documento.setTipo(this.documentoTipo);
        documento.setNumero(this.documentoNumero);
        Empresa empresa = new Empresa();
        empresa.setDocumento(documento);
        LoginRequest request = new LoginRequest();
        request.setUsuario(usuario);
        request.setEmpresa(empresa);
        log.debug("[login] Por hacer login con " + request);
        this.doingLogin = true;
        String path = "/v2/login/ch/PT";
        Pair responsePair = this.restConnector.genericPostWithResponseHeader((Object)request, LoginResponse.class, "/v2/login/ch/PT");
        this.doingLogin = false;
        return responsePair;
    }

    public String getAccessToken() throws RestConnectorException {
        String accessToken = (String)this.cache.get("accessToken");
        if (StringUtil.isEmpty((String)accessToken)) {
            Pair<LoginResponse, MultivaluedMap<String, Object>> loginResponse = this.login();
            accessToken = this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)loginResponse.getValue()));
        }
        if (StringUtil.isEmpty((String)accessToken)) {
            throw new ApplicationException("Se produjo un error al intentar obtener el accessToken de la cache");
        }
        return accessToken;
    }

    protected String generateAccessTokenFromResponseHeader(MultivaluedMap<String, Object> responseHeaders) {
        String xUid = null;
        List xUidList = (List)responseHeaders.get((Object)"x-uid");
        if (xUidList != null && !xUidList.isEmpty()) {
            xUid = (String)xUidList.get(0);
        }
        if (xUid == null || xUid.trim().isEmpty()) {
            throw new RuntimeException("[updateAccessToken] No se pudo obtener el parametro [x-uid] del response header");
        }
        String xAccessToken = null;
        List xAccessTokenList = (List)responseHeaders.get((Object)"x-access-token");
        if (xAccessTokenList != null && !xAccessTokenList.isEmpty()) {
            xAccessToken = (String)xAccessTokenList.get(0);
        }
        if (xAccessToken == null || xAccessToken.trim().isEmpty()) {
            throw new RuntimeException("[updateAccessToken] No se pudo obtener el parametro [x-access-token] del response header");
        }
        String accessToken = Base64.getEncoder().encodeToString((xUid + ":" + xAccessToken).getBytes(StandardCharsets.UTF_8));
        log.debug("[generateAccessToken] AccessToken actualizado y codificado a base64 [" + accessToken + "]. Lo guardo en la cache");
        this.cache.put("accessToken", (Object)accessToken, Integer.valueOf(this.accessTokenTtl));
        return accessToken;
    }

    public String generateUploadToken() throws RestConnectorException {
        log.debug("[generateUploadToken] Por obtener el token para subir el archivo");
        String path = "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT";
        EmpresaArchivoTokenResponse empresaArchivoTokenResponse = (EmpresaArchivoTokenResponse)this.restConnector.genericPost((Object)new EmpresaArchivoTokenRequest(), EmpresaArchivoTokenResponse.class, "/archivo/token/sistema/CASH/accion/SUBIR/ch/PT");
        String uploadToken = null;
        List<Token> tokens = empresaArchivoTokenResponse.getToken();
        if (tokens != null && !tokens.isEmpty()) {
            uploadToken = tokens.get(0).getToken();
        }
        if (uploadToken == null || uploadToken.trim().isEmpty()) {
            throw new RuntimeException("[generateUploadToken] No se pudo obtener el parametro [tokenLista.token] del response");
        }
        log.debug("[generateUploadToken] Token para subir el archivo recuperado [" + uploadToken + "]");
        return uploadToken;
    }

    public EmpresaArchivoByIdResponse consultaEstadoArchivo(String archivoId) throws RestConnectorException {
        String path = "/archivo/estado/prod/" + this.docProd + "/adherentes/" + this.adherente + "/" + archivoId + "/ch/PT";
        Pair response = this.restConnector.genericGetWithResponseHeader(null, EmpresaArchivoByIdResponse.class, ErrorResponse.class, path, null);
        this.generateAccessTokenFromResponseHeader((MultivaluedMap<String, Object>)((MultivaluedMap)response.getValue()));
        return (EmpresaArchivoByIdResponse)response.getKey();
    }

    public EmpresaArchivoErroresResponse consultaErroresArchivo(String archivoId, Integer pagAct, Integer pagCant) throws RestConnectorException {
        if (pagAct == null) {
            pagAct = 1;
        }
        if (pagCant == null) {
            pagCant = 300;
        }
        String path = "/prod/" + this.docProd + "/adherentes/" + this.adherente + "/pagos/errores-en-archivo/" + archivoId + "/ch/PT?pag-act=" + pagAct + "&pag-cant=" + pagCant;
        return (EmpresaArchivoErroresResponse)this.restConnector.genericGet(null, EmpresaArchivoErroresResponse.class, ErrorResponse.class, path);
    }
}

