package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentIdentification implements Serializable {

    @JsonProperty("Standard")
    private String standard;

    @JsonProperty("TypeVersion")
    private String typeVersion;

    @JsonProperty("InstanceIdentifier")
    private String instanceIdentifier;

    @JsonProperty("Type")
    private String type;

    @JsonProperty("CreationDateAndTime")
    private String creationDateAndTime;

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public String getTypeVersion() {
        return typeVersion;
    }

    public void setTypeVersion(String typeVersion) {
        this.typeVersion = typeVersion;
    }

    public String getInstanceIdentifier() {
        return instanceIdentifier;
    }

    public void setInstanceIdentifier(String instanceIdentifier) {
        this.instanceIdentifier = instanceIdentifier;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCreationDateAndTime() {
        return creationDateAndTime;
    }

    public void setCreationDateAndTime(String creationDateAndTime) {
        this.creationDateAndTime = creationDateAndTime;
    }

    @Override
    public String toString() {
        return "DocumentIdentification [" +
                ((standard != null) ? "standard=" + standard + ", " : "") +
                ((typeVersion != null) ? "typeVersion=" + typeVersion + ", " : "") +
                ((instanceIdentifier != null) ? "instanceIdentifier=" + instanceIdentifier + ", " : "") +
                ((type != null) ? "type=" + type + ", " : "") +
                ((creationDateAndTime != null) ? "creationDateAndTime=" + creationDateAndTime + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentIdentification that = (DocumentIdentification) o;
        return Objects.equals(standard, that.standard) && Objects.equals(typeVersion, that.typeVersion) && Objects.equals(instanceIdentifier, that.instanceIdentifier) && Objects.equals(type, that.type) && Objects.equals(creationDateAndTime, that.creationDateAndTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(standard, typeVersion, instanceIdentifier, type, creationDateAndTime);
    }
}