package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payer implements Serializable {

    @JsonProperty("gln")
    private String gln;

    @JsonProperty("additionalPartyIdentification")
    private List<AdditionalPartyIdentification> additionalPartyIdentification;

    public String getGln() {
        return gln;
    }

    public void setGln(String gln) {
        this.gln = gln;
    }

    public List<AdditionalPartyIdentification> getAdditionalPartyIdentification() {
        return additionalPartyIdentification;
    }

    public void setAdditionalPartyIdentification(List<AdditionalPartyIdentification> additionalPartyIdentification) {
        this.additionalPartyIdentification = additionalPartyIdentification;
    }

    @Override
    public String toString() {
        return "Payer [" +
                ((gln != null) ? "gln=" + gln + ", " : "") +
                ((additionalPartyIdentification != null) ? "additionalPartyIdentification=" + Arrays.toString(additionalPartyIdentification.toArray()) + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payer payer = (Payer) o;
        return Objects.equals(gln, payer.gln) && Objects.equals(additionalPartyIdentification, payer.additionalPartyIdentification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gln, additionalPartyIdentification);
    }
}