package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BasicPartyRegistrationMessage implements Serializable {

    @JsonProperty("StandardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader standardBusinessDocumentHeader;

    @JsonProperty("basicPartyRegistration")
    private BasicPartyRegistration basicPartyRegistration;

    @JsonProperty("transaction")
    private Transaction transaction;

    public StandardBusinessDocumentHeader getStandardBusinessDocumentHeader() {
        return standardBusinessDocumentHeader;
    }

    public void setStandardBusinessDocumentHeader(StandardBusinessDocumentHeader standardBusinessDocumentHeader) {
        this.standardBusinessDocumentHeader = standardBusinessDocumentHeader;
    }

    public BasicPartyRegistration getBasicPartyRegistration() {
        return basicPartyRegistration;
    }

    public void setBasicPartyRegistration(BasicPartyRegistration basicPartyRegistration) {
        this.basicPartyRegistration = basicPartyRegistration;
    }

    public Transaction getTransaction() {
        return transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public String toString() {
        return "BasicPartyRegistrationMessage [" +
                ((standardBusinessDocumentHeader != null) ? "standardBusinessDocumentHeader=" + standardBusinessDocumentHeader + ", " : "") +
                ((basicPartyRegistration != null) ? "basicPartyRegistration=" + basicPartyRegistration + ", " : "") +
                ((transaction != null) ? "transaction=" + transaction + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BasicPartyRegistrationMessage that = (BasicPartyRegistrationMessage) o;
        return Objects.equals(standardBusinessDocumentHeader, that.standardBusinessDocumentHeader) && Objects.equals(basicPartyRegistration, that.basicPartyRegistration) && Objects.equals(transaction, that.transaction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(standardBusinessDocumentHeader, basicPartyRegistration, transaction);
    }
}