package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Invoice implements Serializable {

    private final static String INVOICE_TYPE_CODE_DEFAULT_VALUE = "INVOICE";

    @JsonProperty("creationDateTime")
    private String creationDateTime;

    @JsonProperty("documentStatusCode")
    private String documentStatusCode;

    @JsonProperty("documentActionCode")
    private String documentActionCode;

    @JsonProperty("invoiceIdentification")
    private Identification invoiceIdentification;

    @JsonProperty("invoiceCurrencyCode")
    private String invoiceCurrencyCode;

    @JsonProperty("invoiceType")
    private String invoiceType;

    @JsonProperty("buyer")
    private PartyInRole buyer;

    @JsonProperty("seller")
    private PartyInRole seller;

    @JsonProperty("taxCurrencyInformation")
    private List<TaxCurrencyInformation> taxCurrencyInformation;

    @JsonProperty("invoiceLineItem")
    private List<InvoiceLineItem> invoiceLineItem;

    @JsonProperty("entityIdentification")
    private String entityIdentification;

    @JsonProperty("invoiceTypeCode")
    private String invoiceTypeCode;

    public Invoice() {
    }

    // Constructor comodo para RemittanceAdviceIN (aplicacion)
    public Invoice(String entityIdentification) {
        this(entityIdentification, INVOICE_TYPE_CODE_DEFAULT_VALUE);
    }

    public Invoice(String entityIdentification, String invoiceTypeCode) {
        this.entityIdentification = entityIdentification;
        this.invoiceTypeCode = invoiceTypeCode;
    }

    public String getCreationDateTime() {
        return creationDateTime;
    }

    public void setCreationDateTime(String creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public String getDocumentStatusCode() {
        return documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public String getDocumentActionCode() {
        return documentActionCode;
    }

    public void setDocumentActionCode(String documentActionCode) {
        this.documentActionCode = documentActionCode;
    }

    public Identification getInvoiceIdentification() {
        return invoiceIdentification;
    }

    public void setInvoiceIdentification(Identification invoiceIdentification) {
        this.invoiceIdentification = invoiceIdentification;
    }

    public String getInvoiceCurrencyCode() {
        return invoiceCurrencyCode;
    }

    public void setInvoiceCurrencyCode(String invoiceCurrencyCode) {
        this.invoiceCurrencyCode = invoiceCurrencyCode;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public PartyInRole getBuyer() {
        return buyer;
    }

    public void setBuyer(PartyInRole buyer) {
        this.buyer = buyer;
    }

    public PartyInRole getSeller() {
        return seller;
    }

    public void setSeller(PartyInRole seller) {
        this.seller = seller;
    }

    public List<TaxCurrencyInformation> getTaxCurrencyInformation() {
        return taxCurrencyInformation;
    }

    public void setTaxCurrencyInformation(List<TaxCurrencyInformation> taxCurrencyInformation) {
        this.taxCurrencyInformation = taxCurrencyInformation;
    }

    public List<InvoiceLineItem> getInvoiceLineItem() {
        return invoiceLineItem;
    }

    public void setInvoiceLineItem(List<InvoiceLineItem> invoiceLineItem) {
        this.invoiceLineItem = invoiceLineItem;
    }

    public String getEntityIdentification() {
        return entityIdentification;
    }

    public void setEntityIdentification(String entityIdentification) {
        this.entityIdentification = entityIdentification;
    }

    public String getInvoiceTypeCode() {
        return invoiceTypeCode;
    }

    public void setInvoiceTypeCode(String invoiceTypeCode) {
        this.invoiceTypeCode = invoiceTypeCode;
    }

    @Override
    public String toString() {
        return "Invoice [" +
                ((creationDateTime != null) ? "creationDateTime='" + creationDateTime + "', " : "") +
                ((documentStatusCode != null) ? "documentStatusCode='" + documentStatusCode + "', " : "") +
                ((documentActionCode != null) ? "documentActionCode='" + documentActionCode + "', " : "") +
                ((invoiceIdentification != null) ? "invoiceIdentification=" + invoiceIdentification + ", " : "") +
                ((invoiceCurrencyCode != null) ? "invoiceCurrencyCode='" + invoiceCurrencyCode + "', " : "") +
                ((invoiceType != null) ? "invoiceType='" + invoiceType + "', " : "") +
                ((buyer != null) ? "buyer=" + buyer + ", " : "") +
                ((seller != null) ? "seller=" + seller + ", " : "") +
                ((taxCurrencyInformation != null) ? "taxCurrencyInformation=" + Arrays.toString(taxCurrencyInformation.toArray()) + ", " : "") +
                ((invoiceLineItem != null) ? "invoiceLineItem=" + Arrays.toString(invoiceLineItem.toArray()) + ", " : "") +
                ((entityIdentification != null) ? "entityIdentification='" + entityIdentification + "', " : "") +
                ((invoiceTypeCode != null) ? "invoiceTypeCode='" + invoiceTypeCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Invoice invoice = (Invoice) o;
        return Objects.equals(creationDateTime, invoice.creationDateTime) && Objects.equals(documentStatusCode, invoice.documentStatusCode) && Objects.equals(documentActionCode, invoice.documentActionCode) && Objects.equals(invoiceIdentification, invoice.invoiceIdentification) && Objects.equals(invoiceCurrencyCode, invoice.invoiceCurrencyCode) && Objects.equals(invoiceType, invoice.invoiceType) && Objects.equals(buyer, invoice.buyer) && Objects.equals(seller, invoice.seller) && Objects.equals(taxCurrencyInformation, invoice.taxCurrencyInformation) && Objects.equals(invoiceLineItem, invoice.invoiceLineItem) && Objects.equals(entityIdentification, invoice.entityIdentification) && Objects.equals(invoiceTypeCode, invoice.invoiceTypeCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creationDateTime, documentStatusCode, documentActionCode, invoiceIdentification, invoiceCurrencyCode, invoiceType, buyer, seller, taxCurrencyInformation, invoiceLineItem, entityIdentification, invoiceTypeCode);
    }
}