package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentMethod implements Serializable {

    @JsonProperty("paymentMethodCode")
    private String paymentMethodCode;

    @JsonProperty("paymentMethodType")
    private String paymentMethodType;

    public PaymentMethod() {
    }

    public PaymentMethod(String paymentMethodCode) {
        this(paymentMethodCode, null);
    }

    public PaymentMethod(String paymentMethodCode, String paymentMethodType) {
        this.paymentMethodCode = paymentMethodCode;
        this.paymentMethodType = paymentMethodType;
    }

    public String getPaymentMethodCode() {
        return paymentMethodCode;
    }

    public void setPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
    }

    public String getPaymentMethodType() {
        return paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    @Override
    public String toString() {
        return "PaymentMethod [" +
                ((paymentMethodCode != null) ? "paymentMethodCode='" + paymentMethodCode + "', " : "") +
                ((paymentMethodType != null) ? "paymentMethodType='" + paymentMethodType + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentMethod that = (PaymentMethod) o;
        return Objects.equals(paymentMethodCode, that.paymentMethodCode) && Objects.equals(paymentMethodType, that.paymentMethodType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentMethodCode, paymentMethodType);
    }
}