package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Extension implements Serializable {

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("party")
    private Party party;

    @JsonProperty("remitTo")
    private PartyInRole remitTo;

    @JsonProperty("settlementLineItem")
    private List<SettlementLineItem> settlementLineItems;

    @JsonProperty("internalReference")
    private String internalReference;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public Extension() {
    }

    public Extension(String reference) {
        this(reference, (Party) null);
    }

    public Extension(String reference, String internalReference) {
        this.reference = reference;
        this.internalReference = internalReference;
    }

    public Extension(Party party) {
        this(null, party);
    }

    public Extension(String reference, Party party) {
        this.reference = reference;
        this.party = party;
    }

    public Extension(String reference, List<SettlementLineItem> settlementLineItems) {
        this.reference = reference;
        this.settlementLineItems = settlementLineItems;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Party getParty() {
        return party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public PartyInRole getRemitTo() {
        return remitTo;
    }

    public void setRemitTo(PartyInRole remitTo) {
        this.remitTo = remitTo;
    }

    public List<SettlementLineItem> getSettlementLineItems() {
        return settlementLineItems;
    }

    public void setSettlementLineItems(List<SettlementLineItem> settlementLineItems) {
        this.settlementLineItems = settlementLineItems;
    }

    @Override
    public String toString() {
        return "Extension [" +
                ((reference != null) ? "reference='" + reference + "', " : "") +
                ((party != null) ? "party=" + party + ", " : "") +
                ((remitTo != null) ? "remitTo=" + remitTo + ", " : "") +
                ((settlementLineItems != null) ? "settlementLineItems=" + Arrays.toString(settlementLineItems.toArray()) + ", " : "") +
                ((internalReference != null) ? "internalReference='" + internalReference + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Extension extension = (Extension) o;
        return Objects.equals(reference, extension.reference) && Objects.equals(party, extension.party) && Objects.equals(remitTo, extension.remitTo) && Objects.equals(settlementLineItems, extension.settlementLineItems) && Objects.equals(internalReference, extension.internalReference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reference, party, remitTo, settlementLineItems, internalReference);
    }
}