package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentTerms implements Serializable {

    @JsonProperty("paymentMethod")
    private PaymentMethod paymentMethod;

    @JsonProperty("@paymentTermsType")
    private String paymentTermsType;

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getPaymentTermsType() {
        return paymentTermsType;
    }

    public void setPaymentTermsType(String paymentTermsType) {
        this.paymentTermsType = paymentTermsType;
    }

    @Override
    public String toString() {
        return "PaymentTerms [" +
                ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "") +
                ((paymentTermsType != null) ? "paymentTermsType='" + paymentTermsType + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentTerms that = (PaymentTerms) o;
        return Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(paymentTermsType, that.paymentTermsType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentMethod, paymentTermsType);
    }
}