package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ShipTo implements Serializable {

    @JsonProperty("partyAddress")
    private PartyAddress partyAddress;

    public PartyAddress getPartyAddress() {
        return partyAddress;
    }

    public void setPartyAddress(PartyAddress partyAddress) {
        this.partyAddress = partyAddress;
    }

    @Override
    public String toString() {
        return "ShipTo [" +
                ((partyAddress != null) ? "partyAddress=" + partyAddress + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ShipTo shipTo = (ShipTo) o;
        return Objects.equals(partyAddress, shipTo.partyAddress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partyAddress);
    }
}