package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BasicPartyRegistration implements Serializable {

    @JsonProperty("basicPartyRegistrationIdentification")
    private Identification basicPartyRegistrationIdentification;

    @JsonProperty("documentActionCode")
    private String documentActionCode;

    @JsonProperty("party")
    private Party party;

    @JsonProperty("extension")
    private Extension extension;

    public Identification getBasicPartyRegistrationIdentification() {
        return basicPartyRegistrationIdentification;
    }

    public void setBasicPartyRegistrationIdentification(Identification basicPartyRegistrationIdentification) {
        this.basicPartyRegistrationIdentification = basicPartyRegistrationIdentification;
    }

    public String getDocumentActionCode() {
        return documentActionCode;
    }

    public void setDocumentActionCode(String documentActionCode) {
        this.documentActionCode = documentActionCode;
    }

    public Party getParty() {
        return party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public Extension getExtension() {
        return extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    @Override
    public String toString() {
        return "BasicPartyRegistration [" +
                ((basicPartyRegistrationIdentification != null) ? "basicPartyRegistrationIdentification=" + basicPartyRegistrationIdentification + ", " : "") +
                ((documentActionCode != null) ? "documentActionCode='" + documentActionCode + "', " : "") +
                ((party != null) ? "party=" + party + ", " : "") +
                ((extension != null) ? "extension=" + extension + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BasicPartyRegistration that = (BasicPartyRegistration) o;
        return Objects.equals(basicPartyRegistrationIdentification, that.basicPartyRegistrationIdentification) && Objects.equals(documentActionCode, that.documentActionCode) && Objects.equals(party, that.party) && Objects.equals(extension, that.extension);
    }

    @Override
    public int hashCode() {
        return Objects.hash(basicPartyRegistrationIdentification, documentActionCode, party, extension);
    }
}