package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DutyFeeTaxRegistration implements Serializable {

    @JsonProperty("dutyFeeTaxRegistrationID")
    private String dutyFeeTaxRegistrationId;

    public String getDutyFeeTaxRegistrationId() {
        return dutyFeeTaxRegistrationId;
    }

    public void setDutyFeeTaxRegistrationId(String dutyFeeTaxRegistrationId) {
        this.dutyFeeTaxRegistrationId = dutyFeeTaxRegistrationId;
    }

    @Override
    public String toString() {
        return "DutyFeeTaxRegistration [" +
                ((dutyFeeTaxRegistrationId != null) ? "dutyFeeTaxRegistrationId='" + dutyFeeTaxRegistrationId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DutyFeeTaxRegistration that = (DutyFeeTaxRegistration) o;
        return Objects.equals(dutyFeeTaxRegistrationId, that.dutyFeeTaxRegistrationId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(dutyFeeTaxRegistrationId);
    }
}