package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Extension implements Serializable {

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("party")
    private Party party;

    @JsonProperty("remitTo")
    private PartyInRole remitTo;

    @JsonProperty("payer")
    private PartyInRole payer;

    @JsonProperty("settlementLineItem")
    private List<SettlementLineItem> settlementLineItems;

    @JsonProperty("internalReference")
    private String internalReference;

    @JsonProperty("settlementTotalAmountDiscountsAndCharges")
    private String settlementTotalAmountDiscountsAndCharges;

    @JsonProperty("settlementTotalAmountPaymentsReceived")
    private String settlementTotalAmountPaymentsReceived;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public Extension() {
    }

    public Extension(String reference) {
        this(reference, (Party) null);
    }

    public Extension(String reference, String internalReference) {
        this.reference = reference;
        this.internalReference = internalReference;
    }

    public Extension(Party party) {
        this(null, party);
    }

    public Extension(String reference, Party party) {
        this.reference = reference;
        this.party = party;
    }

    public Extension(String reference, List<SettlementLineItem> settlementLineItems) {
        this.reference = reference;
        this.settlementLineItems = settlementLineItems;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Party getParty() {
        return party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public PartyInRole getRemitTo() {
        return remitTo;
    }

    public void setRemitTo(PartyInRole remitTo) {
        this.remitTo = remitTo;
    }

    public List<SettlementLineItem> getSettlementLineItems() {
        return settlementLineItems;
    }

    public void setSettlementLineItems(List<SettlementLineItem> settlementLineItems) {
        this.settlementLineItems = settlementLineItems;
    }

    public PartyInRole getPayer() {
        return payer;
    }

    public void setPayer(PartyInRole payer) {
        this.payer = payer;
    }

    public String getSettlementTotalAmountDiscountsAndCharges() {
        return settlementTotalAmountDiscountsAndCharges;
    }

    public void setSettlementTotalAmountDiscountsAndCharges(String settlementTotalAmountDiscountsAndCharges) {
        this.settlementTotalAmountDiscountsAndCharges = settlementTotalAmountDiscountsAndCharges;
    }

    public String getSettlementTotalAmountPaymentsReceived() {
        return settlementTotalAmountPaymentsReceived;
    }

    public void setSettlementTotalAmountPaymentsReceived(String settlementTotalAmountPaymentsReceived) {
        this.settlementTotalAmountPaymentsReceived = settlementTotalAmountPaymentsReceived;
    }

    public String getInternalReference() {
        return internalReference;
    }

    public void setInternalReference(String internalReference) {
        this.internalReference = internalReference;
    }

    @Override
    public String toString() {
        return "Extension [" +
                ((reference != null) ? "reference='" + reference + "', " : "") +
                ((party != null) ? "party=" + party + ", " : "") +
                ((remitTo != null) ? "remitTo=" + remitTo + ", " : "") +
                ((payer != null) ? "payer=" + payer + ", " : "") +
                ((settlementLineItems != null) ? "settlementLineItems=" + Arrays.toString(settlementLineItems.toArray()) + ", " : "") +
                ((internalReference != null) ? "internalReference='" + internalReference + "', " : "") +
                ((settlementTotalAmountDiscountsAndCharges != null) ? "settlementTotalAmountDiscountsAndCharges='" + settlementTotalAmountDiscountsAndCharges + "', " : "") +
                ((settlementTotalAmountPaymentsReceived != null) ? "settlementTotalAmountPaymentsReceived='" + settlementTotalAmountPaymentsReceived + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Extension extension = (Extension) o;
        return Objects.equals(reference, extension.reference) && Objects.equals(party, extension.party) && Objects.equals(remitTo, extension.remitTo) && Objects.equals(payer, extension.payer) && Objects.equals(settlementLineItems, extension.settlementLineItems) && Objects.equals(internalReference, extension.internalReference) && Objects.equals(settlementTotalAmountDiscountsAndCharges, extension.settlementTotalAmountDiscountsAndCharges) && Objects.equals(settlementTotalAmountPaymentsReceived, extension.settlementTotalAmountPaymentsReceived);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reference, party, remitTo, payer, settlementLineItems, internalReference, settlementTotalAmountDiscountsAndCharges, settlementTotalAmountPaymentsReceived);
    }
}