package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Identification implements Serializable {

    @JsonProperty("entityIdentification")
    private String entityIdentification;

    @JsonProperty("contentOwner")
    private PartyInRole contentOwner;

    @JsonProperty("creationDateTime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date creationDateTime;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public Identification() {
    }

    public Identification(String entityIdentification) {
        this(entityIdentification, null);
    }

    public Identification(PartyInRole contentOwner) {
        this(null, contentOwner);
    }

    public Identification(String entityIdentification, PartyInRole contentOwner) {
        this.entityIdentification = entityIdentification;
        this.contentOwner = contentOwner;
    }

    public String getEntityIdentification() {
        return entityIdentification;
    }

    public void setEntityIdentification(String entityIdentification) {
        this.entityIdentification = entityIdentification;
    }

    public PartyInRole getContentOwner() {
        return contentOwner;
    }

    public void setContentOwner(PartyInRole contentOwner) {
        this.contentOwner = contentOwner;
    }

    public Date getCreationDateTime() {
        return creationDateTime;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    @Override
    public String toString() {
        return "Identification [" +
                ((entityIdentification != null) ? "entityIdentification='" + entityIdentification + "', " : "") +
                ((contentOwner != null) ? "contentOwner=" + contentOwner + ", " : "") +
                ((creationDateTime != null) ? "creationDateTime=" + creationDateTime + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Identification that = (Identification) o;
        return Objects.equals(entityIdentification, that.entityIdentification) && Objects.equals(contentOwner, that.contentOwner) && Objects.equals(creationDateTime, that.creationDateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityIdentification, contentOwner, creationDateTime);
    }
}