package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrderDetails implements Serializable {

    @JsonProperty("purchaseOrder")
    private Identification purchaseOrder;

    @JsonProperty("salesOrder")
    private Identification salesOrder;

    public Identification getPurchaseOrder() {
        return purchaseOrder;
    }

    public void setPurchaseOrder(Identification purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public Identification getSalesOrder() {
        return salesOrder;
    }

    public void setSalesOrder(Identification salesOrder) {
        this.salesOrder = salesOrder;
    }

    @Override
    public String toString() {
        return "OrderDetails [" +
                ((purchaseOrder != null) ? "purchaseOrder=" + purchaseOrder + ", " : "") +
                ((salesOrder != null) ? "salesOrder=" + salesOrder + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderDetails that = (OrderDetails) o;
        return Objects.equals(purchaseOrder, that.purchaseOrder) && Objects.equals(salesOrder, that.salesOrder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(purchaseOrder, salesOrder);
    }
}