package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PartyInRole implements Serializable {

    @JsonProperty("gln")
    private String gln;

    @JsonProperty("additionalPartyIdentification")
    private List<AdditionalPartyIdentification> additionalPartyIdentification;

    @JsonProperty("address")
    private PartyAddress address;

    @JsonProperty("country")
    private String country;

    @JsonProperty("partyRoleCode")
    private String partyRoleCode;

    @JsonProperty("partyRoleCode")
    private Code partyRoleCodeAsCode;

    @JsonProperty("financialInstitutionInformation")
    private List<FinancialInstitutionInformation> financialInstitutionInformationList;

    @JsonProperty("dutyFeeTaxRegistration")
    private DutyFeeTaxRegistration dutyFeeTaxRegistration;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public PartyInRole() {
    }

    public PartyInRole(String gln) {
        this(gln, (List<AdditionalPartyIdentification>) null, null);
    }

    public PartyInRole(String gln, List<AdditionalPartyIdentification> additionalPartyIdentification) {
        this(gln, additionalPartyIdentification, null);
    }

    public PartyInRole(String gln, String additionalPartyIdentificationTypeCode, String additionalPartyIdentificationText) {
        this(gln, Collections.singletonList(new AdditionalPartyIdentification(additionalPartyIdentificationTypeCode, additionalPartyIdentificationText)));
    }

    public PartyInRole(String gln, List<AdditionalPartyIdentification> additionalPartyIdentification, String partyRoleCode) {
        this(gln, additionalPartyIdentification, partyRoleCode, null);
    }

    public PartyInRole(FinancialInstitutionInformation financialInstitutionInformation) {
        this(Collections.singletonList(financialInstitutionInformation));
    }

    public PartyInRole(List<FinancialInstitutionInformation> financialInstitutionInformationList) {
        this(null, null, null, financialInstitutionInformationList);
    }

    public PartyInRole(String gln, List<AdditionalPartyIdentification> additionalPartyIdentification, String partyRoleCode, List<FinancialInstitutionInformation> financialInstitutionInformationList) {
        this.gln = gln;
        this.additionalPartyIdentification = additionalPartyIdentification;
        this.partyRoleCode = partyRoleCode;
    }

    public String getGln() {
        return gln;
    }

    public void setGln(String gln) {
        this.gln = gln;
    }

    public List<AdditionalPartyIdentification> getAdditionalPartyIdentification() {
        return additionalPartyIdentification;
    }

    public void setAdditionalPartyIdentification(List<AdditionalPartyIdentification> additionalPartyIdentification) {
        this.additionalPartyIdentification = additionalPartyIdentification;
    }

    public String getPartyRoleCode() {
        return partyRoleCode;
    }

    public void setPartyRoleCode(String partyRoleCode) {
        this.partyRoleCode = partyRoleCode;
    }

    public List<FinancialInstitutionInformation> getFinancialInstitutionInformationList() {
        return financialInstitutionInformationList;
    }

    public void setFinancialInstitutionInformationList(List<FinancialInstitutionInformation> financialInstitutionInformationList) {
        this.financialInstitutionInformationList = financialInstitutionInformationList;
    }

    public PartyAddress getAddress() {
        return address;
    }

    public void setAddress(PartyAddress address) {
        this.address = address;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Code getPartyRoleCodeAsCode() {
        return partyRoleCodeAsCode;
    }

    public void setPartyRoleCodeAsCode(Code partyRoleCodeAsCode) {
        this.partyRoleCodeAsCode = partyRoleCodeAsCode;
    }

    public DutyFeeTaxRegistration getDutyFeeTaxRegistration() {
        return dutyFeeTaxRegistration;
    }

    public void setDutyFeeTaxRegistration(DutyFeeTaxRegistration dutyFeeTaxRegistration) {
        this.dutyFeeTaxRegistration = dutyFeeTaxRegistration;
    }

    @Override
    public String toString() {
        return "PartyInRole [" +
                ((gln != null) ? "gln='" + gln + "', " : "") +
                ((additionalPartyIdentification != null) ? "additionalPartyIdentification=" + Arrays.toString(additionalPartyIdentification.toArray()) + ", " : "") +
                ((address != null) ? "address=" + address + ", " : "") +
                ((country != null) ? "country='" + country + "', " : "") +
                ((partyRoleCode != null) ? "partyRoleCode='" + partyRoleCode + "', " : "") +
                ((partyRoleCodeAsCode != null) ? "partyRoleCodeAsCode=" + partyRoleCodeAsCode + ", " : "") +
                ((financialInstitutionInformationList != null) ? "financialInstitutionInformationList=" + Arrays.toString(financialInstitutionInformationList.toArray()) + ", " : "") +
                ((dutyFeeTaxRegistration != null) ? "dutyFeeTaxRegistration=" + dutyFeeTaxRegistration + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PartyInRole that = (PartyInRole) o;
        return Objects.equals(gln, that.gln) && Objects.equals(additionalPartyIdentification, that.additionalPartyIdentification) && Objects.equals(address, that.address) && Objects.equals(country, that.country) && Objects.equals(partyRoleCode, that.partyRoleCode) && Objects.equals(partyRoleCodeAsCode, that.partyRoleCodeAsCode) && Objects.equals(financialInstitutionInformationList, that.financialInstitutionInformationList) && Objects.equals(dutyFeeTaxRegistration, that.dutyFeeTaxRegistration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gln, additionalPartyIdentification, address, country, partyRoleCode, partyRoleCodeAsCode, financialInstitutionInformationList, dutyFeeTaxRegistration);
    }
}