package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentMethod implements Serializable {

    @JsonProperty("paymentMethodCode")
    private String paymentMethodCode;

    @JsonProperty("paymentMethodCode")
    private Code paymentMethodCodeAsCode;

    @JsonProperty("paymentMethodType")
    private String paymentMethodType;

    @JsonProperty("automatedClearingHousePaymentFormat")
    private Code automatedClearingHousePaymentFormat;

    public PaymentMethod() {
    }

    public PaymentMethod(String paymentMethodCode) {
        this(paymentMethodCode, null);
    }

    public PaymentMethod(String paymentMethodCode, String paymentMethodType) {
        this.paymentMethodCode = paymentMethodCode;
        this.paymentMethodType = paymentMethodType;
    }

    public PaymentMethod(Code paymentMethodCodeAsCode, Code automatedClearingHousePaymentFormat) {
        this.paymentMethodCodeAsCode = paymentMethodCodeAsCode;
        this.automatedClearingHousePaymentFormat = automatedClearingHousePaymentFormat;
    }

    public String getPaymentMethodCode() {
        return paymentMethodCode;
    }

    public void setPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
    }

    public Code getPaymentMethodCodeAsCode() {
        return paymentMethodCodeAsCode;
    }

    public void setPaymentMethodCodeAsCode(Code paymentMethodCodeAsCode) {
        this.paymentMethodCodeAsCode = paymentMethodCodeAsCode;
    }

    public String getPaymentMethodType() {
        return paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public Code getAutomatedClearingHousePaymentFormat() {
        return automatedClearingHousePaymentFormat;
    }

    public void setAutomatedClearingHousePaymentFormat(Code automatedClearingHousePaymentFormat) {
        this.automatedClearingHousePaymentFormat = automatedClearingHousePaymentFormat;
    }

    @Override
    public String toString() {
        return "PaymentMethod [" +
                ((paymentMethodCode != null) ? "paymentMethodCode='" + paymentMethodCode + "', " : "") +
                ((paymentMethodCodeAsCode != null) ? "paymentMethodCodeAsCode=" + paymentMethodCodeAsCode + ", " : "") +
                ((paymentMethodType != null) ? "paymentMethodType='" + paymentMethodType + "', " : "") +
                ((automatedClearingHousePaymentFormat != null) ? "automatedClearingHousePaymentFormat=" + automatedClearingHousePaymentFormat + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentMethod that = (PaymentMethod) o;
        return Objects.equals(paymentMethodCode, that.paymentMethodCode) && Objects.equals(paymentMethodCodeAsCode, that.paymentMethodCodeAsCode) && Objects.equals(paymentMethodType, that.paymentMethodType) && Objects.equals(automatedClearingHousePaymentFormat, that.automatedClearingHousePaymentFormat);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentMethodCode, paymentMethodCodeAsCode, paymentMethodType, automatedClearingHousePaymentFormat);
    }
}