package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettlementLineItem implements Serializable {

    @JsonProperty("lineItemNumber")
    private String lineItemNumber;

    @JsonProperty("paymentDueDate")
    private String paymentDueDate;

    @JsonProperty("paymentEffectiveDate")
    private String paymentEffectiveDate;

    @JsonProperty("taxAmount")
    private String taxAmount;

    @JsonProperty("amountTax")
    private String amountTax;

    @JsonProperty("paidQuantity")
    private String paidQuantity;

    @JsonProperty("documentType")
    private String documentType;

    @JsonProperty("amountRemainingToPay")
    private String amountRemainingToPay;

    @JsonProperty("paymentMethod")
    private PaymentMethod paymentMethod;

    @JsonProperty("orderDetails")
    private List<OrderDetails> orderDetails;

    @JsonProperty("amountPaid")
    private String amountPaid;

    @JsonProperty("amountPaid")
    private AmountWithCurrency amountPaidWithCurrency;

    @JsonProperty("invoice")
    private Invoice invoice;

    @JsonProperty("settlementParty")
    private List<PartyInRole> settlementParty;

    @JsonProperty("documentPayItem")
    private String documentPayItem;
    private String customerReference;
    private String chargebackCustomerReference;
    private String reasonCode;

    @JsonProperty("originalAmount")
    private AmountWithCurrency originalAmount;

    @JsonProperty("requestForPayment")
    private Identification requestForPayment;

    public String getLineItemNumber() {
        return lineItemNumber;
    }

    public void setLineItemNumber(String lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    public String getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(String amountPaid) {
        this.amountPaid = amountPaid;
    }

    public AmountWithCurrency getOriginalAmount() {
        return originalAmount;
    }

    public void setOriginalAmount(AmountWithCurrency originalAmount) {
        this.originalAmount = originalAmount;
    }

    public Invoice getInvoice() {
        return invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public List<PartyInRole> getSettlementParty() {
        return settlementParty;
    }

    public void setSettlementParty(List<PartyInRole> settlementParty) {
        this.settlementParty = settlementParty;
    }

    public String getCustomerReference() {
        return customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getChargebackCustomerReference() {
        return chargebackCustomerReference;
    }

    public void setChargebackCustomerReference(String chargebackCustomerReference) {
        this.chargebackCustomerReference = chargebackCustomerReference;
    }

    public String getReasonCode() {
        return reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getDocumentPayItem() {
        return documentPayItem;
    }

    public void setDocumentPayItem(String documentPayItem) {
        this.documentPayItem = documentPayItem;
    }

    public String getPaymentDueDate() {
        return paymentDueDate;
    }

    public void setPaymentDueDate(String paymentDueDate) {
        this.paymentDueDate = paymentDueDate;
    }

    public String getPaymentEffectiveDate() {
        return paymentEffectiveDate;
    }

    public void setPaymentEffectiveDate(String paymentEffectiveDate) {
        this.paymentEffectiveDate = paymentEffectiveDate;
    }

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getAmountTax() {
        return amountTax;
    }

    public void setAmountTax(String amountTax) {
        this.amountTax = amountTax;
    }

    public String getPaidQuantity() {
        return paidQuantity;
    }

    public void setPaidQuantity(String paidQuantity) {
        this.paidQuantity = paidQuantity;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getAmountRemainingToPay() {
        return amountRemainingToPay;
    }

    public void setAmountRemainingToPay(String amountRemainingToPay) {
        this.amountRemainingToPay = amountRemainingToPay;
    }

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public List<OrderDetails> getOrderDetails() {
        return orderDetails;
    }

    public void setOrderDetails(List<OrderDetails> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public AmountWithCurrency getAmountPaidWithCurrency() {
        return amountPaidWithCurrency;
    }

    public void setAmountPaidWithCurrency(AmountWithCurrency amountPaidWithCurrency) {
        this.amountPaidWithCurrency = amountPaidWithCurrency;
    }

    public Identification getRequestForPayment() {
        return requestForPayment;
    }

    public void setRequestForPayment(Identification requestForPayment) {
        this.requestForPayment = requestForPayment;
    }

    @Override
    public String toString() {
        return "SettlementLineItem [" +
                ((lineItemNumber != null) ? "lineItemNumber='" + lineItemNumber + "', " : "") +
                ((paymentDueDate != null) ? "paymentDueDate='" + paymentDueDate + "', " : "") +
                ((paymentEffectiveDate != null) ? "paymentEffectiveDate='" + paymentEffectiveDate + "', " : "") +
                ((taxAmount != null) ? "taxAmount='" + taxAmount + "', " : "") +
                ((amountTax != null) ? "amountTax='" + amountTax + "', " : "") +
                ((paidQuantity != null) ? "paidQuantity='" + paidQuantity + "', " : "") +
                ((documentType != null) ? "documentType='" + documentType + "', " : "") +
                ((amountRemainingToPay != null) ? "amountRemainingToPay='" + amountRemainingToPay + "', " : "") +
                ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "") +
                ((orderDetails != null) ? "orderDetails=" + Arrays.toString(orderDetails.toArray()) + ", " : "") +
                ((amountPaid != null) ? "amountPaid='" + amountPaid + "', " : "") +
                ((amountPaidWithCurrency != null) ? "amountPaidWithCurrency=" + amountPaidWithCurrency + ", " : "") +
                ((invoice != null) ? "invoice=" + invoice + ", " : "") +
                ((settlementParty != null) ? "settlementParty=" + Arrays.toString(settlementParty.toArray()) + ", " : "") +
                ((documentPayItem != null) ? "documentPayItem='" + documentPayItem + "', " : "") +
                ((customerReference != null) ? "customerReference='" + customerReference + "', " : "") +
                ((chargebackCustomerReference != null) ? "chargebackCustomerReference='" + chargebackCustomerReference + "', " : "") +
                ((reasonCode != null) ? "reasonCode='" + reasonCode + "', " : "") +
                ((originalAmount != null) ? "originalAmount=" + originalAmount + ", " : "") +
                ((requestForPayment != null) ? "requestForPayment=" + requestForPayment + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettlementLineItem that = (SettlementLineItem) o;
        return Objects.equals(lineItemNumber, that.lineItemNumber) && Objects.equals(paymentDueDate, that.paymentDueDate) && Objects.equals(paymentEffectiveDate, that.paymentEffectiveDate) && Objects.equals(taxAmount, that.taxAmount) && Objects.equals(amountTax, that.amountTax) && Objects.equals(paidQuantity, that.paidQuantity) && Objects.equals(documentType, that.documentType) && Objects.equals(amountRemainingToPay, that.amountRemainingToPay) && Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(orderDetails, that.orderDetails) && Objects.equals(amountPaid, that.amountPaid) && Objects.equals(amountPaidWithCurrency, that.amountPaidWithCurrency) && Objects.equals(invoice, that.invoice) && Objects.equals(settlementParty, that.settlementParty) && Objects.equals(documentPayItem, that.documentPayItem) && Objects.equals(customerReference, that.customerReference) && Objects.equals(chargebackCustomerReference, that.chargebackCustomerReference) && Objects.equals(reasonCode, that.reasonCode) && Objects.equals(originalAmount, that.originalAmount) && Objects.equals(requestForPayment, that.requestForPayment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lineItemNumber, paymentDueDate, paymentEffectiveDate, taxAmount, amountTax, paidQuantity, documentType, amountRemainingToPay, paymentMethod, orderDetails, amountPaid, amountPaidWithCurrency, invoice, settlementParty, documentPayItem, customerReference, chargebackCustomerReference, reasonCode, originalAmount, requestForPayment);
    }
}