package ar.com.sdd.praapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PayloadACKResponse implements Serializable {

    @JsonProperty("acknowledgeResult")
    private String acknowledgeResult;

    @JsonProperty("correlationId")
    private String correlationId;

    public String getAcknowledgeResult() {
        return acknowledgeResult;
    }

    public void setAcknowledgeResult(String acknowledgeResult) {
        this.acknowledgeResult = acknowledgeResult;
    }

    public String getCorrelationId() {
        return correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Override
    public String toString() {
        return "PayloadACKResponse [" +
                ((acknowledgeResult != null) ? "acknowledgeResult='" + acknowledgeResult + "', " : "") +
                ((correlationId != null) ? "correlationId='" + correlationId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayloadACKResponse that = (PayloadACKResponse) o;
        return Objects.equals(acknowledgeResult, that.acknowledgeResult) && Objects.equals(correlationId, that.correlationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(acknowledgeResult, correlationId);
    }
}