package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FinancialInstitutionInformation implements Serializable {

    @JsonProperty("financialInstitutionName")
    private String financialInstitutionName;

    @JsonProperty("financialAccount")
    private FinancialAccount financialAccount;

    @JsonProperty("additionalPartyIdentification")
    private List<AdditionalPartyIdentification> additionalPartyIdentification;

    public String getFinancialInstitutionName() {
        return financialInstitutionName;
    }

    public void setFinancialInstitutionName(String financialInstitutionName) {
        this.financialInstitutionName = financialInstitutionName;
    }

    public FinancialAccount getFinancialAccount() {
        return financialAccount;
    }

    public void setFinancialAccount(FinancialAccount financialAccount) {
        this.financialAccount = financialAccount;
    }

    public List<AdditionalPartyIdentification> getAdditionalPartyIdentification() {
        return additionalPartyIdentification;
    }

    public void setAdditionalPartyIdentification(List<AdditionalPartyIdentification> additionalPartyIdentification) {
        this.additionalPartyIdentification = additionalPartyIdentification;
    }

    @Override
    public String toString() {
        return "FinancialInstitutionInformation ["
                + ((financialInstitutionName != null) ? "financialInstitutionName=" + financialInstitutionName + ", " : "")
                + ((financialAccount != null) ? "financialAccount=" + financialAccount + ", " : "")
                + ((additionalPartyIdentification != null) ? "additionalPartyIdentification=" + Arrays.toString(additionalPartyIdentification.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FinancialInstitutionInformation that = (FinancialInstitutionInformation) o;
        return Objects.equals(financialInstitutionName, that.financialInstitutionName) && Objects.equals(financialAccount, that.financialAccount) && Objects.equals(additionalPartyIdentification, that.additionalPartyIdentification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(financialInstitutionName, financialAccount, additionalPartyIdentification);
    }
}