package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Identification implements Serializable {

    @JsonProperty("entityIdentification")
    private String entityIdentification;

    @JsonProperty("contentOwner")
    private PartyInRole contentOwner;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public Identification() {
    }

    public Identification(String entityIdentification) {
        this(entityIdentification, null);
    }

    public Identification(PartyInRole contentOwner) {
        this(null, contentOwner);
    }

    public Identification(String entityIdentification, PartyInRole contentOwner) {
        this.entityIdentification = entityIdentification;
        this.contentOwner = contentOwner;
    }

    public String getEntityIdentification() {
        return entityIdentification;
    }

    public void setEntityIdentification(String entityIdentification) {
        this.entityIdentification = entityIdentification;
    }

    public PartyInRole getContentOwner() {
        return contentOwner;
    }

    public void setContentOwner(PartyInRole contentOwner) {
        this.contentOwner = contentOwner;
    }

    @Override
    public String toString() {
        return "Identification [" +
                ((entityIdentification != null) ? "entityIdentification='" + entityIdentification + "', " : "") +
                ((contentOwner != null) ? "contentOwner=" + contentOwner + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Identification that = (Identification) o;
        return Objects.equals(entityIdentification, that.entityIdentification) && Objects.equals(contentOwner, that.contentOwner);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityIdentification, contentOwner);
    }
}