package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PartyAddress implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("streetAddressOne")
    private String streetAddressOne;

    @JsonProperty("streetAddressTwo")
    private String streetAddressTwo;

    @JsonProperty("city")
    private String city;

    @JsonProperty("postalCode")
    private String postalCode;

    @JsonProperty("pOBoxNumber")
    private String pOBoxNumber;

    @JsonProperty("country")
    private String country;

    @JsonProperty("countryName")
    private String countryName;

    @JsonProperty("countryCode")
    private String countryCode;

    @JsonProperty("countyCode")
    private String countyCode;

    @JsonProperty("state")
    private String state;

    @JsonProperty("currencyOfPartyCode")
    private String currencyOfPartyCode;

    @JsonProperty("community")
    private String community;

    @JsonProperty("taxCode")
    private String taxCode;

    @JsonProperty("liabilityCode")
    private String liabilityCode;

    @JsonProperty("liabilitySupplier")
    private String liabilitySupplier;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStreetAddressOne() {
        return streetAddressOne;
    }

    public void setStreetAddressOne(String streetAddressOne) {
        this.streetAddressOne = streetAddressOne;
    }

    public String getStreetAddressTwo() {
        return streetAddressTwo;
    }

    public void setStreetAddressTwo(String streetAddressTwo) {
        this.streetAddressTwo = streetAddressTwo;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getpOBoxNumber() {
        return pOBoxNumber;
    }

    public void setpOBoxNumber(String pOBoxNumber) {
        this.pOBoxNumber = pOBoxNumber;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCurrencyOfPartyCode() {
        return currencyOfPartyCode;
    }

    public void setCurrencyOfPartyCode(String currencyOfPartyCode) {
        this.currencyOfPartyCode = currencyOfPartyCode;
    }

    public String getCommunity() {
        return community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getLiabilityCode() {
        return liabilityCode;
    }

    public void setLiabilityCode(String liabilityCode) {
        this.liabilityCode = liabilityCode;
    }

    public String getLiabilitySupplier() {
        return liabilitySupplier;
    }

    public void setLiabilitySupplier(String liabilitySupplier) {
        this.liabilitySupplier = liabilitySupplier;
    }

    @Override
    public String toString() {
        return "PartyAddress [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((streetAddressOne != null) ? "streetAddressOne='" + streetAddressOne + "', " : "") +
                ((streetAddressTwo != null) ? "streetAddressTwo='" + streetAddressTwo + "', " : "") +
                ((city != null) ? "city='" + city + "', " : "") +
                ((postalCode != null) ? "postalCode='" + postalCode + "', " : "") +
                ((pOBoxNumber != null) ? "pOBoxNumber='" + pOBoxNumber + "', " : "") +
                ((country != null) ? "country='" + country + "', " : "") +
                ((countryName != null) ? "countryName='" + countryName + "', " : "") +
                ((countryCode != null) ? "countryCode='" + countryCode + "', " : "") +
                ((countyCode != null) ? "countyCode='" + countyCode + "', " : "") +
                ((state != null) ? "state='" + state + "', " : "") +
                ((currencyOfPartyCode != null) ? "currencyOfPartyCode='" + currencyOfPartyCode + "', " : "") +
                ((community != null) ? "community='" + community + "', " : "") +
                ((taxCode != null) ? "taxCode='" + taxCode + "', " : "") +
                ((liabilityCode != null) ? "liabilityCode='" + liabilityCode + "', " : "") +
                ((liabilitySupplier != null) ? "liabilitySupplier='" + liabilitySupplier + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PartyAddress that = (PartyAddress) o;
        return Objects.equals(name, that.name) && Objects.equals(streetAddressOne, that.streetAddressOne) && Objects.equals(streetAddressTwo, that.streetAddressTwo) && Objects.equals(city, that.city) && Objects.equals(postalCode, that.postalCode) && Objects.equals(pOBoxNumber, that.pOBoxNumber) && Objects.equals(country, that.country) && Objects.equals(countryName, that.countryName) && Objects.equals(countryCode, that.countryCode) && Objects.equals(countyCode, that.countyCode) && Objects.equals(state, that.state) && Objects.equals(currencyOfPartyCode, that.currencyOfPartyCode) && Objects.equals(community, that.community) && Objects.equals(taxCode, that.taxCode) && Objects.equals(liabilityCode, that.liabilityCode) && Objects.equals(liabilitySupplier, that.liabilitySupplier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, streetAddressOne, streetAddressTwo, city, postalCode, pOBoxNumber, country, countryName, countryCode, countyCode, state, currencyOfPartyCode, community, taxCode, liabilityCode, liabilitySupplier);
    }
}