package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Scope implements Serializable {

    @JsonProperty("BusinessService")
    private BusinessService businessService;

    public Scope() {
    }

    public Scope(String businessServiceName, String typeOfServiceTransaction) {
        this.businessService = new BusinessService(businessServiceName, typeOfServiceTransaction);
    }

    public BusinessService getBusinessService() {
        return businessService;
    }

    public void setBusinessService(BusinessService businessService) {
        this.businessService = businessService;
    }

    @Override
    public String toString() {
        return "Scope [" +
                ((businessService != null) ? "businessService=" + businessService + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Scope scope = (Scope) o;
        return Objects.equals(businessService, scope.businessService);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessService);
    }
}