package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Sender implements Serializable {

    @JsonProperty("Identifier")
    private Identifier identifier;

    public Sender() {
    }

    public Sender(String identifierAuthority, String identifierText) {
        this.identifier = new Identifier(identifierAuthority, identifierText);
    }

    public Identifier getIdentifier() {
        return identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public String toString() {
        return "Sender [" +
                ((identifier != null) ? "identifier=" + identifier + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Sender sender = (Sender) o;
        return Objects.equals(identifier, sender.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(identifier);
    }
}