package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TaxCurrencyInformation implements Serializable {

    @JsonProperty("currencyConversionToCode")
    private String currencyConversionToCode;

    public String getCurrencyConversionToCode() {
        return currencyConversionToCode;
    }

    public void setCurrencyConversionToCode(String currencyConversionToCode) {
        this.currencyConversionToCode = currencyConversionToCode;
    }

    @Override
    public String toString() {
        return "TaxCurrencyInformation [" +
                ((currencyConversionToCode != null) ? "currencyConversionToCode='" + currencyConversionToCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TaxCurrencyInformation that = (TaxCurrencyInformation) o;
        return Objects.equals(currencyConversionToCode, that.currencyConversionToCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currencyConversionToCode);
    }
}