package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BusinessService implements Serializable {

    @JsonProperty("BusinessServiceName")
    private String businessServiceName;

    @JsonProperty("ServiceTransaction")
    private ServiceTransaction serviceTransaction;

    public BusinessService() {
    }

    public BusinessService(String businessServiceName, String typeOfServiceTransaction) {
        this.businessServiceName = businessServiceName;
        this.serviceTransaction = new ServiceTransaction(typeOfServiceTransaction);
    }

    public String getBusinessServiceName() {
        return businessServiceName;
    }

    public void setBusinessServiceName(String businessServiceName) {
        this.businessServiceName = businessServiceName;
    }

    public ServiceTransaction getServiceTransaction() {
        return serviceTransaction;
    }

    public void setServiceTransaction(ServiceTransaction serviceTransaction) {
        this.serviceTransaction = serviceTransaction;
    }

    @Override
    public String toString() {
        return "BusinessService [" +
                ((businessServiceName != null) ? "businessServiceName='" + businessServiceName + "', " : "") +
                ((serviceTransaction != null) ? "serviceTransaction=" + serviceTransaction + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BusinessService that = (BusinessService) o;
        return Objects.equals(businessServiceName, that.businessServiceName) && Objects.equals(serviceTransaction, that.serviceTransaction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessServiceName, serviceTransaction);
    }
}