package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryAndTransportInformation implements Serializable {

    @JsonProperty("deliveryOrTransportTerms")
    private DeliveryOrTransportTerms deliveryOrTransportTerms;

    public DeliveryOrTransportTerms getDeliveryOrTransportTerms() {
        return deliveryOrTransportTerms;
    }

    public void setDeliveryOrTransportTerms(DeliveryOrTransportTerms deliveryOrTransportTerms) {
        this.deliveryOrTransportTerms = deliveryOrTransportTerms;
    }

    @Override
    public String toString() {
        return "DeliveryAndTransportInformation [" +
                ((deliveryOrTransportTerms != null) ? "deliveryOrTransportTerms=" + deliveryOrTransportTerms + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeliveryAndTransportInformation that = (DeliveryAndTransportInformation) o;
        return Objects.equals(deliveryOrTransportTerms, that.deliveryOrTransportTerms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryOrTransportTerms);
    }
}