package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Settlement implements Serializable {

    @JsonProperty("creationDateTime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date creationDateTime;

    @JsonProperty("documentStatusCode")
    private String documentStatusCode;

    @JsonProperty("documentActionCode")
    private String documentActionCode;

    @JsonProperty("settlementIdentification")
    private Identification settlementIdentification;

    @JsonProperty("batchIdentification")
    private String batchIdentification;

    @JsonProperty("payer")
    private PartyInRole payer;

    @JsonProperty("remitTo")
    private PartyInRole remitTo;

    @JsonProperty("paymentMethod")
    private PaymentMethod paymentMethod;

    @JsonProperty("settlementCurrency")
    private String settlementCurrency;

    @JsonProperty("totalAmount")
    private String totalAmount;

    @JsonProperty("paymentEffectiveDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date paymentEffectiveDate;

    @JsonProperty("extension")
    private Extension extension;

    @JsonProperty("settlementLineItem")
    private List<SettlementLineItem> settlementLineItems;

    public Date getCreationDateTime() {
        return creationDateTime;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public String getDocumentStatusCode() {
        return documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public String getDocumentActionCode() {
        return documentActionCode;
    }

    public void setDocumentActionCode(String documentActionCode) {
        this.documentActionCode = documentActionCode;
    }

    public Identification getSettlementIdentification() {
        return settlementIdentification;
    }

    public void setSettlementIdentification(Identification settlementIdentification) {
        this.settlementIdentification = settlementIdentification;
    }

    public String getBatchIdentification() {
        return batchIdentification;
    }

    public void setBatchIdentification(String batchIdentification) {
        this.batchIdentification = batchIdentification;
    }

    public PartyInRole getPayer() {
        return payer;
    }

    public void setPayer(PartyInRole payer) {
        this.payer = payer;
    }

    public PartyInRole getRemitTo() {
        return remitTo;
    }

    public void setRemitTo(PartyInRole remitTo) {
        this.remitTo = remitTo;
    }

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getSettlementCurrency() {
        return settlementCurrency;
    }

    public void setSettlementCurrency(String settlementCurrency) {
        this.settlementCurrency = settlementCurrency;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getPaymentEffectiveDate() {
        return paymentEffectiveDate;
    }

    public void setPaymentEffectiveDate(Date paymentEffectiveDate) {
        this.paymentEffectiveDate = paymentEffectiveDate;
    }

    public Extension getExtension() {
        return extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public List<SettlementLineItem> getSettlementLineItems() {
        return settlementLineItems;
    }

    public void setSettlementLineItems(List<SettlementLineItem> settlementLineItems) {
        this.settlementLineItems = settlementLineItems;
    }

    @Override
    public String toString() {
        return "Settlement [" +
                ((creationDateTime != null) ? "creationDateTime=" + creationDateTime + ", " : "") +
                ((documentStatusCode != null) ? "documentStatusCode='" + documentStatusCode + "', " : "") +
                ((documentActionCode != null) ? "documentActionCode='" + documentActionCode + "', " : "") +
                ((settlementIdentification != null) ? "settlementIdentification=" + settlementIdentification + ", " : "") +
                ((batchIdentification != null) ? "batchIdentification='" + batchIdentification + "', " : "") +
                ((payer != null) ? "payer=" + payer + ", " : "") +
                ((remitTo != null) ? "remitTo=" + remitTo + ", " : "") +
                ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "") +
                ((settlementCurrency != null) ? "settlementCurrency='" + settlementCurrency + "', " : "") +
                ((totalAmount != null) ? "totalAmount='" + totalAmount + "', " : "") +
                ((paymentEffectiveDate != null) ? "paymentEffectiveDate=" + paymentEffectiveDate + ", " : "") +
                ((extension != null) ? "extension=" + extension + ", " : "") +
                ((settlementLineItems != null) ? "settlementLineItems=" + Arrays.toString(settlementLineItems.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Settlement that = (Settlement) o;
        return Objects.equals(creationDateTime, that.creationDateTime) && Objects.equals(documentStatusCode, that.documentStatusCode) && Objects.equals(documentActionCode, that.documentActionCode) && Objects.equals(settlementIdentification, that.settlementIdentification) && Objects.equals(batchIdentification, that.batchIdentification) && Objects.equals(payer, that.payer) && Objects.equals(remitTo, that.remitTo) && Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(settlementCurrency, that.settlementCurrency) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(paymentEffectiveDate, that.paymentEffectiveDate) && Objects.equals(extension, that.extension) && Objects.equals(settlementLineItems, that.settlementLineItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creationDateTime, documentStatusCode, documentActionCode, settlementIdentification, batchIdentification, payer, remitTo, paymentMethod, settlementCurrency, totalAmount, paymentEffectiveDate, extension, settlementLineItems);
    }
}