/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.praapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.ThreadUtil;
import ar.com.sdd.praapi.core.PraApiConnectorContext;
import ar.com.sdd.praapi.io.CommonError;
import ar.com.sdd.praapi.io.PayloadACKResponse;
import ar.com.sdd.praapi.io.RemittanceAdviceINRequest;
import ar.com.sdd.praapi.io.RemittanceAdviceINResponse;
import ar.com.sdd.praapi.io.SalesInvoiceINRequest;
import ar.com.sdd.praapi.io.SalesInvoiceINResponse;
import ar.com.sdd.praapi.model.OperationDetail;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PraApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(PraApiConnector.class);
    private final RestConnector restConnector;
    private final String GET_TOKEN_URL = "https://login.microsoftonline.com/933c9cbe-35d3-4416-abbd-ddd1bca5879c";
    private final String xApiKey;
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;

    public PraApiConnector(PraApiConnectorContext context) {
        this.xApiKey = context.getPraApiXApiKey();
        this.clientId = context.getPraApiClientId();
        this.clientSecret = context.getPraApiClientSecret();
        this.scope = context.getPraApiScope();
        log.trace("Creando PraConnector para url [{}] con x-api-key [{}]", (Object)context.getPraApiBaseUrl(), (Object)this.xApiKey);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getPraApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public RemittanceAdviceINResponse remittanceAdviceIN(RemittanceAdviceINRequest request) throws RestConnectorException {
        String path = "/jde/v2/remittanceAdvices/accountsReceivable";
        log.debug("[createPaymentRequest] Request POST procesar crear pago, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (RemittanceAdviceINResponse)this.restConnector.genericPost((Object)request, RemittanceAdviceINResponse.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public String remittanceAdviceOUT(String correlationId) throws RestConnectorException {
        String path = "/jde/v2/remittanceAdvices/accountsReceivable/" + correlationId;
        log.debug("[remittanceAdviceOUT] Request GET obtener Remittance Advice con path [{}]", (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (String)this.restConnector.genericGet(null, String.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public SalesInvoiceINResponse salesInvoiceIN(SalesInvoiceINRequest request) throws RestConnectorException {
        String path = "/jde/v2/salesInvoices";
        log.debug("[salesInvoiceINResponse] Request POST procesar crear pago, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (SalesInvoiceINResponse)this.restConnector.genericPost((Object)request, SalesInvoiceINResponse.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw lastException;
    }

    public String salesInvoiceOUT(String correlationId) throws RestConnectorException {
        String path = "/jde/v2/salesInvoices/" + correlationId;
        log.debug("[salesInvoiceOUT] Request GET obtener Sales Invoice con path [{}]", (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (String)this.restConnector.genericGet(null, String.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public String partinBuyerOUT(String correlationId) throws RestConnectorException {
        String path = "/jde/v2/partiesInformations/buyer/" + correlationId;
        log.debug("[partinBuyerOUT] Request GET obtener Party Information Buyer (PartinBuyer) con path [{}]", (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (String)this.restConnector.genericGet(null, String.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public OperationDetail[] getAllPending() throws RestConnectorException {
        String path = "/common/v2/payloads/pending/correlationIDs";
        log.debug("[getAllPending] Request GET obtener operaciones pendientes, path [{}]", (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (OperationDetail[])this.restConnector.genericGet(null, OperationDetail[].class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public PayloadACKResponse[] payloadACK(String correlationId) throws RestConnectorException {
        String path = "/common/v2/payloads/collected/correlationIDs";
        log.debug("[payloadACK] Request POST payloadACK para el correlationID [{}] path [{}]", (Object)correlationId, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (PayloadACKResponse[])this.restConnector.genericPost((Object)new String[]{correlationId}, PayloadACKResponse[].class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public String getCommercialAccountSummariesOUT(String correlationId) throws RestConnectorException {
        String path = "/jde/v2/commercialAccountSummaries/accountsReceivable/" + correlationId;
        log.debug("[commercialAccountSummariesOUT] Request GET commercialAccountSummariesOUT para el correlationID [{}] path [{}]", (Object)correlationId, (Object)path);
        return (String)this.restConnector.genericGet(null, String.class, CommonError.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", (Object)this.xApiKey);
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(PraApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("client_id", this.clientId);
            form.param("client_secret", this.clientSecret);
            form.param("scope", this.scope);
            form.param("grant_type", "client_credentials");
            log.debug("[getAccessToken] Por recuperar token con clientId [{}], clientSecret [{}] y scope [{}]", (Object)this.clientId, (Object)this.clientSecret, (Object)this.scope);
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = "https://login.microsoftonline.com/933c9cbe-35d3-4416-abbd-ddd1bca5879c";
            RestConnector connector = new RestConnector(environment, null);
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/oauth2/v2.0/token", "application/json", "application/x-www-form-urlencoded");
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}]segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }
}

