package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StandardBusinessDocumentHeader implements Serializable {

    @JsonProperty("HeaderVersion")
    private String headerVersion;

    @JsonProperty("Sender")
    private Sender sender;

    @JsonProperty("Receiver")
    private Receiver receiver;

    @JsonProperty("DocumentIdentification")
    private DocumentIdentification documentIdentification;

    @JsonProperty("BusinessScope")
    private BusinessScope businessScope;

    public String getHeaderVersion() {
        return headerVersion;
    }

    public void setHeaderVersion(String headerVersion) {
        this.headerVersion = headerVersion;
    }

    public Sender getSender() {
        return sender;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public Receiver getReceiver() {
        return receiver;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public DocumentIdentification getDocumentIdentification() {
        return documentIdentification;
    }

    public void setDocumentIdentification(DocumentIdentification documentIdentification) {
        this.documentIdentification = documentIdentification;
    }

    public BusinessScope getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(BusinessScope businessScope) {
        this.businessScope = businessScope;
    }

    @Override
    public String toString() {
        return "StandardBusinessDocumentHeader [" +
                ((headerVersion != null) ? "headerVersion=" + headerVersion + ", " : "") +
                ((sender != null) ? "sender=" + sender + ", " : "") +
                ((receiver != null) ? "receiver=" + receiver + ", " : "") +
                ((documentIdentification != null) ? "documentIdentification=" + documentIdentification + ", " : "") +
                ((businessScope != null) ? "businessScope=" + businessScope + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StandardBusinessDocumentHeader that = (StandardBusinessDocumentHeader) o;
        return Objects.equals(headerVersion, that.headerVersion) && Objects.equals(sender, that.sender) && Objects.equals(receiver, that.receiver) && Objects.equals(documentIdentification, that.documentIdentification) && Objects.equals(businessScope, that.businessScope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(headerVersion, sender, receiver, documentIdentification, businessScope);
    }
}