package ar.com.sdd.praapi.io;

import ar.com.sdd.praapi.model.InvoiceMessage;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SalesInvoiceINRequest implements Serializable {

    @JsonProperty("invoiceMessage")
    private InvoiceMessage invoiceMessage;

    public InvoiceMessage getInvoiceMessage() {
        return invoiceMessage;
    }

    public void setInvoiceMessage(InvoiceMessage invoiceMessage) {
        this.invoiceMessage = invoiceMessage;
    }

    @Override
    public String toString() {
        return "SalesInvoiceINRequest [" +
                ((invoiceMessage != null) ? "invoiceMessage=" + invoiceMessage + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SalesInvoiceINRequest that = (SalesInvoiceINRequest) o;
        return Objects.equals(invoiceMessage, that.invoiceMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invoiceMessage);
    }
}