package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperationDetail implements Serializable {

    @JsonProperty("correlationId")
    private String correlationId;

    @JsonProperty("endpoint")
    private String endpoint;

    @JsonProperty("partner")
    private String partner;

    @JsonProperty("publishingSystem")
    private String publishingSystem;

    @JsonProperty("receiver")
    private String receiver;

    @JsonProperty("restMethod")
    private String restMethod;

    @JsonProperty("sender")
    private String sender;

    @JsonProperty("transactionType")
    private String transactionType;

    public String getCorrelationId() {
        return correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getPartner() {
        return partner;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public String getPublishingSystem() {
        return publishingSystem;
    }

    public void setPublishingSystem(String publishingSystem) {
        this.publishingSystem = publishingSystem;
    }

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getRestMethod() {
        return restMethod;
    }

    public void setRestMethod(String restMethod) {
        this.restMethod = restMethod;
    }

    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    @Override
    public String toString() {
        return "OperationDetail{" +
                "correlationId='" + correlationId + '\'' +
                ", endpoint='" + endpoint + '\'' +
                ", partner='" + partner + '\'' +
                ", publishingSystem='" + publishingSystem + '\'' +
                ", receiver='" + receiver + '\'' +
                ", restMethod='" + restMethod + '\'' +
                ", sender='" + sender + '\'' +
                ", transactionType='" + transactionType + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperationDetail that = (OperationDetail) o;
        return Objects.equals(correlationId, that.correlationId) && Objects.equals(endpoint, that.endpoint) && Objects.equals(partner, that.partner) && Objects.equals(publishingSystem, that.publishingSystem) && Objects.equals(receiver, that.receiver) && Objects.equals(restMethod, that.restMethod) && Objects.equals(sender, that.sender) && Objects.equals(transactionType, that.transactionType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(correlationId, endpoint, partner, publishingSystem, receiver, restMethod, sender, transactionType);
    }
}