package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettlementIdentification implements Serializable {

    @JsonProperty("entityIdentification")
    private String entityIdentification;

    public String getEntityIdentification() {
        return entityIdentification;
    }

    public void setEntityIdentification(String entityIdentification) {
        this.entityIdentification = entityIdentification;
    }

    @Override
    public String toString() {
        return "SettlementIdentification [" +
                ((entityIdentification != null) ? "entityIdentification=" + entityIdentification + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettlementIdentification that = (SettlementIdentification) o;
        return Objects.equals(entityIdentification, that.entityIdentification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityIdentification);
    }
}