package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommunicationChannel implements Serializable {

    @JsonProperty("communicationChannelCode")
    private CommunicationChannelCode communicationChannelCode;

    @JsonProperty("communicationValue")
    private String communicationValue;

    public CommunicationChannelCode getCommunicationChannelCode() {
        return communicationChannelCode;
    }

    public void setCommunicationChannelCode(CommunicationChannelCode communicationChannelCode) {
        this.communicationChannelCode = communicationChannelCode;
    }

    public String getCommunicationValue() {
        return communicationValue;
    }

    public void setCommunicationValue(String communicationValue) {
        this.communicationValue = communicationValue;
    }

    @Override
    public String toString() {
        return "CommunicationChannel [" +
                ((communicationChannelCode != null) ? "communicationChannelCode=" + communicationChannelCode + ", " : "") +
                ((communicationValue != null) ? "communicationValue='" + communicationValue + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommunicationChannel that = (CommunicationChannel) o;
        return Objects.equals(communicationChannelCode, that.communicationChannelCode) && Objects.equals(communicationValue, that.communicationValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(communicationChannelCode, communicationValue);
    }
}