package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Party implements Serializable {

    @JsonProperty("isPartyActive")
    private String isPartyActive;

    @JsonProperty("informationProviderOfParty")
    private InformationProviderOfParty informationProviderOfParty;

    @JsonProperty("partyInRole")
    private PartyInRole partyInRole;

    @JsonProperty("partyAddress")
    private PartyAddress partyAddress;

//    @JsonProperty("partyContact")
//    private PartyContact partyContact;

    @JsonProperty("contact")
    private List<Contact> contact;

    @JsonProperty("customerType")
    private String customerType;

    @JsonProperty("chain")
    private String chain;

    @JsonProperty("channel")
    private String channel;

    @JsonProperty("subChannel")
    private String subChannel;

    @JsonProperty("priceList")
    private String priceList;

    @JsonProperty("salesRegion")
    private String salesRegion;

    @JsonProperty("salesSubRegion")
    private String salesSubRegion;

    @JsonProperty("subChain")
    private String subChain;

    @JsonProperty("companyRegistrationNumber")
    private String companyRegistrationNumber;

    @JsonProperty("salesRepresentative")
    private SalesRepresentative salesRepresentative;

    @JsonProperty("parent")
    private Parent parent;

    @JsonProperty("paymentTerms")
    private PaymentTerms paymentTerms;

    @JsonProperty("status")
    private String status;

    @JsonProperty("vATRegistrationNumber")
    private String vATRegistrationNumber;

    @JsonProperty("exciseRegistrationNumber")
    private String exciseRegistrationNumber;

    @JsonProperty("financialInstitutionInformation")
    private FinancialInstitutionInformation financialInstitutionInformation;

    @JsonProperty("purchaseOrderRequired")
    private String purchaseOrderRequired;

    @JsonProperty("taxCode")
    private String taxCode;

    @JsonProperty("taxRegistrationNumber")
    private String taxRegistrationNumber;

    @JsonProperty("liabilityCode")
    private String liabilityCode;

    @JsonProperty("liabilitySupplier")
    private String liabilitySupplier;

    @JsonProperty("deliveryAndTransportInformation")
    private DeliveryAndTransportInformation deliveryAndTransportInformation;

    @JsonProperty("accountsReceivableAccountType")
    private String accountsReceivableAccountType;

    @JsonProperty("shippingInstructions")
    private String shippingInstructions;

    @JsonProperty("legalStatus")
    private String legalStatus;

    @JsonProperty("collectionManagerCode")
    private String collectionManagerCode;

    @JsonProperty("abcMarginCustomerGroup")
    private String abcMarginCustomerGroup;

    @JsonProperty("creditCheckLevelCode")
    private String creditCheckLevelCode;

    @JsonProperty("logisticAllowanceCode")
    private String logisticAllowanceCode;

    @JsonProperty("cashAllowanceCode")
    private String cashAllowanceCode;

    @JsonProperty("shipTo")
    private ShipTo shipTo;

    public InformationProviderOfParty getInformationProviderOfParty() {
        return informationProviderOfParty;
    }

    public void setInformationProviderOfParty(InformationProviderOfParty informationProviderOfParty) {
        this.informationProviderOfParty = informationProviderOfParty;
    }

    public PartyInRole getPartyInRole() {
        return partyInRole;
    }

    public void setPartyInRole(PartyInRole partyInRole) {
        this.partyInRole = partyInRole;
    }

    public PartyAddress getPartyAddress() {
        return partyAddress;
    }

    public void setPartyAddress(PartyAddress partyAddress) {
        this.partyAddress = partyAddress;
    }

    public List<Contact> getContact() {
        return contact;
    }

    public void setContact(List<Contact> contact) {
        this.contact = contact;
    }

    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public String getChain() {
        return chain;
    }

    public void setChain(String chain) {
        this.chain = chain;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPriceList() {
        return priceList;
    }

    public void setPriceList(String priceList) {
        this.priceList = priceList;
    }

    public String getSalesRegion() {
        return salesRegion;
    }

    public void setSalesRegion(String salesRegion) {
        this.salesRegion = salesRegion;
    }

    public String getSalesSubRegion() {
        return salesSubRegion;
    }

    public void setSalesSubRegion(String salesSubRegion) {
        this.salesSubRegion = salesSubRegion;
    }

    public String getSubChain() {
        return subChain;
    }

    public void setSubChain(String subChain) {
        this.subChain = subChain;
    }

    public String getCompanyRegistrationNumber() {
        return companyRegistrationNumber;
    }

    public void setCompanyRegistrationNumber(String companyRegistrationNumber) {
        this.companyRegistrationNumber = companyRegistrationNumber;
    }

    public SalesRepresentative getSalesRepresentative() {
        return salesRepresentative;
    }

    public void setSalesRepresentative(SalesRepresentative salesRepresentative) {
        this.salesRepresentative = salesRepresentative;
    }

    public Parent getParent() {
        return parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public PaymentTerms getPaymentTerms() {
        return paymentTerms;
    }

    public void setPaymentTerms(PaymentTerms paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getvATRegistrationNumber() {
        return vATRegistrationNumber;
    }

    public void setvATRegistrationNumber(String vATRegistrationNumber) {
        this.vATRegistrationNumber = vATRegistrationNumber;
    }

    public String getExciseRegistrationNumber() {
        return exciseRegistrationNumber;
    }

    public void setExciseRegistrationNumber(String exciseRegistrationNumber) {
        this.exciseRegistrationNumber = exciseRegistrationNumber;
    }

    public FinancialInstitutionInformation getFinancialInstitutionInformation() {
        return financialInstitutionInformation;
    }

    public void setFinancialInstitutionInformation(FinancialInstitutionInformation financialInstitutionInformation) {
        this.financialInstitutionInformation = financialInstitutionInformation;
    }

    public String getPurchaseOrderRequired() {
        return purchaseOrderRequired;
    }

    public void setPurchaseOrderRequired(String purchaseOrderRequired) {
        this.purchaseOrderRequired = purchaseOrderRequired;
    }

    public String getIsPartyActive() {
        return isPartyActive;
    }

    public void setIsPartyActive(String isPartyActive) {
        this.isPartyActive = isPartyActive;
    }

    public String getSubChannel() {
        return subChannel;
    }

    public void setSubChannel(String subChannel) {
        this.subChannel = subChannel;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getTaxRegistrationNumber() {
        return taxRegistrationNumber;
    }

    public void setTaxRegistrationNumber(String taxRegistrationNumber) {
        this.taxRegistrationNumber = taxRegistrationNumber;
    }

    public String getLiabilityCode() {
        return liabilityCode;
    }

    public void setLiabilityCode(String liabilityCode) {
        this.liabilityCode = liabilityCode;
    }

    public String getLiabilitySupplier() {
        return liabilitySupplier;
    }

    public void setLiabilitySupplier(String liabilitySupplier) {
        this.liabilitySupplier = liabilitySupplier;
    }

    public DeliveryAndTransportInformation getDeliveryAndTransportInformation() {
        return deliveryAndTransportInformation;
    }

    public void setDeliveryAndTransportInformation(DeliveryAndTransportInformation deliveryAndTransportInformation) {
        this.deliveryAndTransportInformation = deliveryAndTransportInformation;
    }

    public String getAccountsReceivableAccountType() {
        return accountsReceivableAccountType;
    }

    public void setAccountsReceivableAccountType(String accountsReceivableAccountType) {
        this.accountsReceivableAccountType = accountsReceivableAccountType;
    }

    public String getShippingInstructions() {
        return shippingInstructions;
    }

    public void setShippingInstructions(String shippingInstructions) {
        this.shippingInstructions = shippingInstructions;
    }

    public String getLegalStatus() {
        return legalStatus;
    }

    public void setLegalStatus(String legalStatus) {
        this.legalStatus = legalStatus;
    }

    public String getCollectionManagerCode() {
        return collectionManagerCode;
    }

    public void setCollectionManagerCode(String collectionManagerCode) {
        this.collectionManagerCode = collectionManagerCode;
    }

    public String getAbcMarginCustomerGroup() {
        return abcMarginCustomerGroup;
    }

    public void setAbcMarginCustomerGroup(String abcMarginCustomerGroup) {
        this.abcMarginCustomerGroup = abcMarginCustomerGroup;
    }

    public String getCreditCheckLevelCode() {
        return creditCheckLevelCode;
    }

    public void setCreditCheckLevelCode(String creditCheckLevelCode) {
        this.creditCheckLevelCode = creditCheckLevelCode;
    }

    public String getLogisticAllowanceCode() {
        return logisticAllowanceCode;
    }

    public void setLogisticAllowanceCode(String logisticAllowanceCode) {
        this.logisticAllowanceCode = logisticAllowanceCode;
    }

    public String getCashAllowanceCode() {
        return cashAllowanceCode;
    }

    public void setCashAllowanceCode(String cashAllowanceCode) {
        this.cashAllowanceCode = cashAllowanceCode;
    }

    public ShipTo getShipTo() {
        return shipTo;
    }

    public void setShipTo(ShipTo shipTo) {
        this.shipTo = shipTo;
    }

    @Override
    public String toString() {
        return "Party [" +
                ((isPartyActive != null) ? "isPartyActive='" + isPartyActive + "', " : "") +
                ((informationProviderOfParty != null) ? "informationProviderOfParty=" + informationProviderOfParty + ", " : "") +
                ((partyInRole != null) ? "partyInRole=" + partyInRole + ", " : "") +
                ((partyAddress != null) ? "partyAddress=" + partyAddress + ", " : "") +
                ((contact != null) ? "contact=" + Arrays.toString(contact.toArray()) + ", " : "") +
                ((customerType != null) ? "customerType='" + customerType + "', " : "") +
                ((chain != null) ? "chain='" + chain + "', " : "") +
                ((channel != null) ? "channel='" + channel + "', " : "") +
                ((subChannel != null) ? "subChannel='" + subChannel + "', " : "") +
                ((priceList != null) ? "priceList='" + priceList + "', " : "") +
                ((salesRegion != null) ? "salesRegion='" + salesRegion + "', " : "") +
                ((salesSubRegion != null) ? "salesSubRegion='" + salesSubRegion + "', " : "") +
                ((subChain != null) ? "subChain='" + subChain + "', " : "") +
                ((companyRegistrationNumber != null) ? "companyRegistrationNumber='" + companyRegistrationNumber + "', " : "") +
                ((salesRepresentative != null) ? "salesRepresentative=" + salesRepresentative + ", " : "") +
                ((parent != null) ? "parent=" + parent + ", " : "") +
                ((paymentTerms != null) ? "paymentTerms=" + paymentTerms + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((vATRegistrationNumber != null) ? "vATRegistrationNumber='" + vATRegistrationNumber + "', " : "") +
                ((exciseRegistrationNumber != null) ? "exciseRegistrationNumber='" + exciseRegistrationNumber + "', " : "") +
                ((financialInstitutionInformation != null) ? "financialInstitutionInformation=" + financialInstitutionInformation + ", " : "") +
                ((purchaseOrderRequired != null) ? "purchaseOrderRequired='" + purchaseOrderRequired + "', " : "") +
                ((taxCode != null) ? "taxCode='" + taxCode + "', " : "") +
                ((taxRegistrationNumber != null) ? "taxRegistrationNumber='" + taxRegistrationNumber + "', " : "") +
                ((liabilityCode != null) ? "liabilityCode='" + liabilityCode + "', " : "") +
                ((liabilitySupplier != null) ? "liabilitySupplier='" + liabilitySupplier + "', " : "") +
                ((deliveryAndTransportInformation != null) ? "deliveryAndTransportInformation=" + deliveryAndTransportInformation + ", " : "") +
                ((accountsReceivableAccountType != null) ? "accountsReceivableAccountType='" + accountsReceivableAccountType + "', " : "") +
                ((shippingInstructions != null) ? "shippingInstructions='" + shippingInstructions + "', " : "") +
                ((legalStatus != null) ? "legalStatus='" + legalStatus + "', " : "") +
                ((collectionManagerCode != null) ? "collectionManagerCode='" + collectionManagerCode + "', " : "") +
                ((abcMarginCustomerGroup != null) ? "abcMarginCustomerGroup='" + abcMarginCustomerGroup + "', " : "") +
                ((creditCheckLevelCode != null) ? "creditCheckLevelCode='" + creditCheckLevelCode + "', " : "") +
                ((logisticAllowanceCode != null) ? "logisticAllowanceCode='" + logisticAllowanceCode + "', " : "") +
                ((cashAllowanceCode != null) ? "cashAllowanceCode='" + cashAllowanceCode + "', " : "") +
                ((shipTo != null) ? "shipTo=" + shipTo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Party party = (Party) o;
        return Objects.equals(isPartyActive, party.isPartyActive) && Objects.equals(informationProviderOfParty, party.informationProviderOfParty) && Objects.equals(partyInRole, party.partyInRole) && Objects.equals(partyAddress, party.partyAddress) && Objects.equals(contact, party.contact) && Objects.equals(customerType, party.customerType) && Objects.equals(chain, party.chain) && Objects.equals(channel, party.channel) && Objects.equals(subChannel, party.subChannel) && Objects.equals(priceList, party.priceList) && Objects.equals(salesRegion, party.salesRegion) && Objects.equals(salesSubRegion, party.salesSubRegion) && Objects.equals(subChain, party.subChain) && Objects.equals(companyRegistrationNumber, party.companyRegistrationNumber) && Objects.equals(salesRepresentative, party.salesRepresentative) && Objects.equals(parent, party.parent) && Objects.equals(paymentTerms, party.paymentTerms) && Objects.equals(status, party.status) && Objects.equals(vATRegistrationNumber, party.vATRegistrationNumber) && Objects.equals(exciseRegistrationNumber, party.exciseRegistrationNumber) && Objects.equals(financialInstitutionInformation, party.financialInstitutionInformation) && Objects.equals(purchaseOrderRequired, party.purchaseOrderRequired) && Objects.equals(taxCode, party.taxCode) && Objects.equals(taxRegistrationNumber, party.taxRegistrationNumber) && Objects.equals(liabilityCode, party.liabilityCode) && Objects.equals(liabilitySupplier, party.liabilitySupplier) && Objects.equals(deliveryAndTransportInformation, party.deliveryAndTransportInformation) && Objects.equals(accountsReceivableAccountType, party.accountsReceivableAccountType) && Objects.equals(shippingInstructions, party.shippingInstructions) && Objects.equals(legalStatus, party.legalStatus) && Objects.equals(collectionManagerCode, party.collectionManagerCode) && Objects.equals(abcMarginCustomerGroup, party.abcMarginCustomerGroup) && Objects.equals(creditCheckLevelCode, party.creditCheckLevelCode) && Objects.equals(logisticAllowanceCode, party.logisticAllowanceCode) && Objects.equals(cashAllowanceCode, party.cashAllowanceCode) && Objects.equals(shipTo, party.shipTo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isPartyActive, informationProviderOfParty, partyInRole, partyAddress, contact, customerType, chain, channel, subChannel, priceList, salesRegion, salesSubRegion, subChain, companyRegistrationNumber, salesRepresentative, parent, paymentTerms, status, vATRegistrationNumber, exciseRegistrationNumber, financialInstitutionInformation, purchaseOrderRequired, taxCode, taxRegistrationNumber, liabilityCode, liabilitySupplier, deliveryAndTransportInformation, accountsReceivableAccountType, shippingInstructions, legalStatus, collectionManagerCode, abcMarginCustomerGroup, creditCheckLevelCode, logisticAllowanceCode, cashAllowanceCode, shipTo);
    }
}