package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SalesRepresentative implements Serializable {

    @JsonProperty("gln")
    private String gln;

    @JsonProperty("additionalPartyIdentification")
    private AdditionalPartyIdentification additionalPartyIdentification;

    public String getGln() {
        return gln;
    }

    public void setGln(String gln) {
        this.gln = gln;
    }

    public AdditionalPartyIdentification getAdditionalPartyIdentification() {
        return additionalPartyIdentification;
    }

    public void setAdditionalPartyIdentification(AdditionalPartyIdentification additionalPartyIdentification) {
        this.additionalPartyIdentification = additionalPartyIdentification;
    }

    @Override
    public String toString() {
        return "SalesRepresentative [" +
                ((gln != null) ? "gln='" + gln + "', " : "") +
                ((additionalPartyIdentification != null) ? "additionalPartyIdentification=" + additionalPartyIdentification + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SalesRepresentative that = (SalesRepresentative) o;
        return Objects.equals(gln, that.gln) && Objects.equals(additionalPartyIdentification, that.additionalPartyIdentification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gln, additionalPartyIdentification);
    }
}