/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.praapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.praapi.core.PraApiConnectorContext;
import ar.com.sdd.praapi.io.RemittanceAdviceINRequest;
import ar.com.sdd.praapi.io.RemittanceAdviceINResponse;
import ar.com.sdd.praapi.io.SalesInvoiceINRequest;
import ar.com.sdd.praapi.io.SalesInvoiceINResponse;
import ar.com.sdd.praapi.model.OperationDetail;
import ar.com.sdd.praapi.util.SimpleCache;
import java.time.temporal.ChronoUnit;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class PraApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(PraApiConnector.class);
    private final RestConnector restConnector;
    private final String GET_TOKEN_URL = "https://login.microsoftonline.com/933c9cbe-35d3-4416-abbd-ddd1bca5879c";
    private final String xApiKey;
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private final SimpleCache<String, String> cache;

    public PraApiConnector(PraApiConnectorContext context) {
        this.xApiKey = context.getPraApiXApiKey();
        this.clientId = context.getPraApiClientId();
        this.clientSecret = context.getPraApiClientSecret();
        this.scope = context.getPraApiScope();
        log.debug((Object)("Creando PraConnector para url [" + context.getPraApiBaseUrl() + "] con x-api-key [" + this.xApiKey + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getPraApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
        this.cache = SimpleCache.builder().maximumSize(1L).expireAfter(1L, ChronoUnit.HOURS).build();
    }

    public RemittanceAdviceINResponse remittanceAdviceIN(RemittanceAdviceINRequest request) throws RestConnectorException {
        String path = "/jde/v2/remittanceAdvices/accountsReceivable";
        log.debug((Object)("[createPaymentRequest] Request POST procesar crear pago, request [" + request + "] path [" + path + "]"));
        return (RemittanceAdviceINResponse)this.restConnector.genericPost((Object)request, RemittanceAdviceINResponse.class, path);
    }

    public SalesInvoiceINResponse salesInvoiceIN(SalesInvoiceINRequest request) throws RestConnectorException {
        String path = "/jde/v2/salesInvoices";
        log.debug((Object)("[salesInvoiceINResponse] Request POST procesar crear pago, request [" + request + "] path [" + path + "]"));
        return (SalesInvoiceINResponse)this.restConnector.genericPost((Object)request, SalesInvoiceINResponse.class, path);
    }

    public OperationDetail[] getAllPending() throws RestConnectorException {
        String path = "/common/v2/payloads/pending/correlationIDs";
        log.debug((Object)("[getAllPending] Request GET obtener operaciones pendientes, path [" + path + "]"));
        return (OperationDetail[])this.restConnector.genericGet(null, OperationDetail[].class, path);
    }

    public String partinBuyerOUT(String correlationId) throws RestConnectorException {
        String path = "/jde/v2/partiesInformations/buyer/" + correlationId;
        log.debug((Object)("[partinBuyerOUT] Request GET obtener Party Information Buyer (PartinBuyer) con path [" + path + "]"));
        return (String)this.restConnector.genericGet(null, String.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", (Object)this.xApiKey);
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken() throws RestConnectorException {
        String accessToken = this.cache.getIfPresent("accessToken");
        if (accessToken == null) {
            Form form = new Form();
            form.param("client_id", this.clientId);
            form.param("client_secret", this.clientSecret);
            form.param("scope", this.scope);
            form.param("grant_type", "client_credentials");
            log.debug((Object)("[getAccessToken] Por recuperar token con clientId [" + this.clientId + "], clientSecret [" + this.clientSecret + "] y scope [" + this.scope + "]"));
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = "https://login.microsoftonline.com/933c9cbe-35d3-4416-abbd-ddd1bca5879c";
            RestConnector connector = new RestConnector(environment, null);
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/oauth2/v2.0/token", "application/json", "application/x-www-form-urlencoded");
            log.debug((Object)("[getAccessToken] Token recuperado [" + tokenOAuth2Response + "]. Lo agrego al a cache"));
            accessToken = tokenOAuth2Response.getAccessToken();
            this.cache.put("accessToken", accessToken);
        }
        return accessToken;
    }
}

