package ar.com.sdd.praapi.io;

import ar.com.sdd.praapi.model.SettlementMessage;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RemittanceAdviceINRequest implements Serializable {

    @JsonProperty("settlementMessage")
    private SettlementMessage settlementMessage;

    public SettlementMessage getSettlementMessage() {
        return settlementMessage;
    }

    public void setSettlementMessage(SettlementMessage settlementMessage) {
        this.settlementMessage = settlementMessage;
    }

    @Override
    public String toString() {
        return "RemittanceAdviceINRequest [" +
                ((settlementMessage != null) ? "settlementMessage=" + settlementMessage + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RemittanceAdviceINRequest that = (RemittanceAdviceINRequest) o;
        return Objects.equals(settlementMessage, that.settlementMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(settlementMessage);
    }
}