package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PartyInRole implements Serializable {

    @JsonProperty("gln")
    private String gln;

    @JsonProperty("additionalPartyIdentification")
    private List<AdditionalPartyIdentification> additionalPartyIdentification;

    @JsonProperty("partyRoleCode")
    private String partyRoleCode;

    public String getGln() {
        return gln;
    }

    public void setGln(String gln) {
        this.gln = gln;
    }

    public List<AdditionalPartyIdentification> getAdditionalPartyIdentification() {
        return additionalPartyIdentification;
    }

    public void setAdditionalPartyIdentification(List<AdditionalPartyIdentification> additionalPartyIdentification) {
        this.additionalPartyIdentification = additionalPartyIdentification;
    }

    public String getPartyRoleCode() {
        return partyRoleCode;
    }

    public void setPartyRoleCode(String partyRoleCode) {
        this.partyRoleCode = partyRoleCode;
    }

    @Override
    public String toString() {
        return "PartyInRole [" +
                ((gln != null) ? "gln='" + gln + "', " : "") +
                ((additionalPartyIdentification != null) ? "additionalPartyIdentification=" + Arrays.toString(additionalPartyIdentification.toArray()) + ", " : "") +
                ((partyRoleCode != null) ? "partyRoleCode='" + partyRoleCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PartyInRole that = (PartyInRole) o;
        return Objects.equals(gln, that.gln) && Objects.equals(additionalPartyIdentification, that.additionalPartyIdentification) && Objects.equals(partyRoleCode, that.partyRoleCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gln, additionalPartyIdentification, partyRoleCode);
    }
}