package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AmountExclusiveAllowancesCharges implements Serializable {

    @JsonProperty("@currencyCode")
    private String currencyCode;

    @JsonProperty("#text")
    private String text;

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "AmountExclusiveAllowancesCharges [" +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((text != null) ? "text='" + text + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AmountExclusiveAllowancesCharges that = (AmountExclusiveAllowancesCharges) o;
        return Objects.equals(currencyCode, that.currencyCode) && Objects.equals(text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currencyCode, text);
    }
}