package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BasicPartyRegistrationIdentification implements Serializable {

    @JsonProperty("entityIdentification")
    private String entityIdentification;

    @JsonProperty("contentOwner")
    private ContentOwner contentOwner;

    public String getEntityIdentification() {
        return entityIdentification;
    }
    public void setEntityIdentification(String entityIdentification) {
        this.entityIdentification = entityIdentification;
    }
    public ContentOwner getContentOwner() {
        return contentOwner;
    }
    public void setContentOwner(ContentOwner contentOwner) {
        this.contentOwner = contentOwner;
    }

    @Override
    public String toString() {
        return "BasicPartyRegistrationIdentification [" +
                ((entityIdentification != null) ? "entityIdentification='" + entityIdentification + "', " : "") +
                ((contentOwner != null) ? "contentOwner=" + contentOwner + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BasicPartyRegistrationIdentification that = (BasicPartyRegistrationIdentification) o;
        return Objects.equals(entityIdentification, that.entityIdentification) && Objects.equals(contentOwner, that.contentOwner);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityIdentification, contentOwner);
    }
}