package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Contact implements Serializable {

    @JsonProperty("contactTypeCode")
    private String contactTypeCode;

    @JsonProperty("personName")
    private String personName;

    @JsonProperty("communicationChannel")
    private List<CommunicationChannel> communicationChannel;

    public String getContactTypeCode() {
        return contactTypeCode;
    }

    public void setContactTypeCode(String contactTypeCode) {
        this.contactTypeCode = contactTypeCode;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public List<CommunicationChannel> getCommunicationChannel() {
        return communicationChannel;
    }

    public void setCommunicationChannel(List<CommunicationChannel> communicationChannel) {
        this.communicationChannel = communicationChannel;
    }

    @Override
    public String toString() {
        return "Contact [" +
                ((contactTypeCode != null) ? "contactTypeCode='" + contactTypeCode + "', " : "") +
                ((personName != null) ? "personName='" + personName + "', " : "") +
                ((communicationChannel != null) ? "communicationChannel=" + Arrays.toString(communicationChannel.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Contact contact = (Contact) o;
        return Objects.equals(contactTypeCode, contact.contactTypeCode) && Objects.equals(personName, contact.personName) && Objects.equals(communicationChannel, contact.communicationChannel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(contactTypeCode, personName, communicationChannel);
    }
}