package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Document implements Serializable {

    @JsonProperty("extension")
    private Extension extension;

    @JsonProperty("basicPartyRegistrationIdentification")
    private BasicPartyRegistrationIdentification basicPartyRegistrationIdentification;

    @JsonProperty("party")
    private Party party;

    public Extension getExtension() {
        return extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public BasicPartyRegistrationIdentification getBasicPartyRegistrationIdentification() {
        return basicPartyRegistrationIdentification;
    }

    public void setBasicPartyRegistrationIdentification(BasicPartyRegistrationIdentification basicPartyRegistrationIdentification) {
        this.basicPartyRegistrationIdentification = basicPartyRegistrationIdentification;
    }

    public Party getParty() {
        return party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    @Override
    public String toString() {
        return "Document [" +
                ((extension != null) ? "extension=" + extension + ", " : "") +
                ((basicPartyRegistrationIdentification != null) ? "basicPartyRegistrationIdentification=" + basicPartyRegistrationIdentification + ", " : "") +
                ((party != null) ? "party=" + party + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Document document = (Document) o;
        return Objects.equals(extension, document.extension) && Objects.equals(basicPartyRegistrationIdentification, document.basicPartyRegistrationIdentification) && Objects.equals(party, document.party);
    }

    @Override
    public int hashCode() {
        return Objects.hash(extension, basicPartyRegistrationIdentification, party);
    }
}