package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FinancialAccount implements Serializable {

    @JsonProperty("financialAccountNumber")
    private String financialAccountNumber;

    @JsonProperty("financialAccountNumberTypeCode")
    private FinancialAccountNumberTypeCode financialAccountNumberTypeCode;

    public String getFinancialAccountNumber() {
        return financialAccountNumber;
    }

    public void setFinancialAccountNumber(String financialAccountNumber) {
        this.financialAccountNumber = financialAccountNumber;
    }

    public FinancialAccountNumberTypeCode getFinancialAccountNumberTypeCode() {
        return financialAccountNumberTypeCode;
    }

    public void setFinancialAccountNumberTypeCode(FinancialAccountNumberTypeCode financialAccountNumberTypeCode) {
        this.financialAccountNumberTypeCode = financialAccountNumberTypeCode;
    }

    @Override
    public String toString() {
        return "FinancialAccount [" +
                ((financialAccountNumber != null) ? "financialAccountNumber='" + financialAccountNumber + "', " : "") +
                ((financialAccountNumberTypeCode != null) ? "financialAccountNumberTypeCode=" + financialAccountNumberTypeCode + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FinancialAccount that = (FinancialAccount) o;
        return Objects.equals(financialAccountNumber, that.financialAccountNumber) && Objects.equals(financialAccountNumberTypeCode, that.financialAccountNumberTypeCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(financialAccountNumber, financialAccountNumberTypeCode);
    }
}