package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FinancialAccountNumberTypeCode implements Serializable {

    @JsonProperty("@codeListVersion")
    private String codeListVersion;

    @JsonProperty("#text")
    private String text;

    public String getCodeListVersion() {
        return codeListVersion;
    }

    public void setCodeListVersion(String codeListVersion) {
        this.codeListVersion = codeListVersion;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "FinancialAccountNumberTypeCode [" +
                ((codeListVersion != null) ? "codeListVersion='" + codeListVersion + "', " : "") +
                ((text != null) ? "text='" + text + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FinancialAccountNumberTypeCode that = (FinancialAccountNumberTypeCode) o;
        return Objects.equals(codeListVersion, that.codeListVersion) && Objects.equals(text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(codeListVersion, text);
    }
}